/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.command;

import com.google.common.base.Ascii;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.PolyhedralZone;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.command.argument.ArgFlag;
import com.moderocky.guardian.command.argument.ArgZone;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.mask.command.ArgOfflinePlayer;
import com.moderocky.guardian.mask.command.ArgPlayer;
import com.moderocky.guardian.mask.command.ArgString;
import com.moderocky.guardian.mask.command.Argument;
import com.moderocky.guardian.mask.command.Commander;
import com.moderocky.guardian.mask.template.WrappedCommand;
import com.moderocky.guardian.util.Messenger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZoneCommand
extends Commander<CommandSender>
implements WrappedCommand {
    @NotNull
    private final GuardianConfig config = Guardian.getInstance().getGuardianConfig();
    @NotNull
    private final Messenger messenger = Guardian.getMessenger();
    @NotNull
    private final GuardianAPI api = Guardian.getApi();
    public static ZoneCommand command;

    public ZoneCommand() {
        command = this;
    }

    @Override
    @NotNull
    public Commander.Main create() {
        return this.command("zone").arg("add", (S sender) -> this.messenger.sendMessage("/zone add <zone_id> <player/uuid>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            String id = (String)input[0];
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            if (!zone.canEdit(sender instanceof Player ? ((Player)sender).getUniqueId() : UUID.randomUUID())) {
                this.messenger.sendMessage("You may not edit this zone.", (CommandSender)sender);
                return;
            }
            OfflinePlayer player = (OfflinePlayer)input[1];
            if (zone.isAllowed(player.getUniqueId())) {
                this.messenger.sendMessage("This player was already added.", (CommandSender)sender);
            } else {
                zone.addPlayer(player.getUniqueId());
                this.messenger.sendMessage("Added a new player to this zone.", (CommandSender)sender);
            }
            this.api.updateCache();
        }, new Argument[]{new ArgZone(), new ArgPlayer()})).arg("create", (S sender) -> this.messenger.sendMessage("/zone create <zone_id>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            if (!(sender instanceof Player)) {
                return;
            }
            Player player = (Player)sender;
            Location l1 = this.api.getWandPosition(player, 1);
            Location l2 = this.api.getWandPosition(player, 2);
            if (l1 == null || l2 == null) {
                this.messenger.sendMessage("Please set zone corners using a zone wand first.", new CommandSender[]{player});
                return;
            }
            if (l1.getWorld() != l2.getWorld() || l1.distanceSquared(l2) > (double)(this.config.maxZoneDiameter * this.config.maxZoneDiameter)) {
                this.messenger.sendMessage("The selected area is larger than " + this.config.maxZoneDiameter + "\u00d7" + this.config.maxZoneDiameter + " blocks in diameter.", new CommandSender[]{player});
                return;
            }
            String id = input[0].toString();
            if (this.api.getZone(id) != null) {
                this.messenger.sendMessage("A zone with the id '" + id + "' already exists.", (CommandSender)sender);
                return;
            }
            CuboidalZone zone = CuboidalZone.createZone(player, id, l1, l2);
            if (!player.isOp() && !this.api.canCreateZone(zone, player)) {
                this.messenger.sendMessage("This zone conflicts with others that you are unable to edit or override.", new CommandSender[]{player});
                return;
            }
            this.api.registerZone(zone);
            this.api.scheduleSave();
            this.api.updateCache();
            this.messenger.sendMessage("A cuboidal zone with the id '" + id + "' has been created.", (CommandSender)sender);
        }, new ArgString().setLabel("zone_id"))).arg("createpoly", (S sender) -> this.messenger.sendMessage("/zone createpoly <zone_id>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            if (!(sender instanceof Player)) {
                return;
            }
            Player player = (Player)sender;
            List<Location> locations = this.api.getPolywandPositions(player);
            if (locations.size() < 4) {
                this.messenger.sendMessage("Please set at least 4 zone vertices using a zone polywand first.", new CommandSender[]{player});
                return;
            }
            World world = locations.get(0).getWorld();
            for (Location location : locations) {
                if (location.getWorld() == world && !(location.distanceSquared(locations.get(0)) > (double)(this.config.maxZoneDiameter * this.config.maxZoneDiameter))) continue;
                this.messenger.sendMessage("The selected area is larger than " + this.config.maxZoneDiameter + "\u00d7" + this.config.maxZoneDiameter + " blocks in diameter.", new CommandSender[]{player});
                return;
            }
            String id = input[0].toString();
            if (this.api.getZone(id) != null) {
                this.messenger.sendMessage("A zone with the id '" + id + "' already exists.", (CommandSender)sender);
                return;
            }
            PolyhedralZone zone = PolyhedralZone.createZone(player, id, locations.toArray(new Location[0]));
            if (!player.isOp() && !this.api.canCreateZone(zone, player)) {
                this.messenger.sendMessage("This zone conflicts with others that you are unable to edit or override.", new CommandSender[]{player});
                return;
            }
            this.api.registerZone(zone);
            this.api.scheduleSave();
            this.api.updateCache();
            this.messenger.sendMessage("A polyhedral zone with the id '" + id + "' has been created.", (CommandSender)sender);
        }, new ArgString().setLabel("zone_id"))).arg("delete", (S sender) -> this.messenger.sendMessage("/zone delete <zone_id>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            String id = input[0].toString();
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            this.api.removeZone(zone);
            this.api.scheduleSave();
            this.api.updateCache();
            this.messenger.sendMessage("A zone with the id '" + id + "' has been removed.", (CommandSender)sender);
        }, new ArgZone())).arg("info", (S sender) -> {
            if (!(sender instanceof Player)) {
                return;
            }
            List<Zone> zones = this.api.getZones(((Player)sender).getLocation().getBlock().getLocation());
            if (zones.isEmpty()) {
                this.messenger.sendMessage("There are no zones at your location.", (CommandSender)sender);
            } else {
                ArrayList names = new ArrayList();
                zones.forEach(zone -> names.add(zone.getKey().toString()));
                this.messenger.sendMessage(new ComponentBuilder("Zones at your location:").append(System.lineSeparator()).append(this.messenger.getBullets(names.toArray(new String[0]))).create(), (CommandSender)sender);
            }
        }, this.arg((S sender, Object[] input) -> {
            if (input[0] == null) {
                if (!(sender instanceof Player)) {
                    return;
                }
                List<Zone> zones = this.api.getZones(((Player)sender).getLocation().getBlock().getLocation());
                if (zones.isEmpty()) {
                    this.messenger.sendMessage("There are no zones at your location.", (CommandSender)sender);
                } else {
                    ArrayList names = new ArrayList();
                    zones.forEach(zone -> names.add(zone.getKey().toString()));
                    this.messenger.sendMessage(new ComponentBuilder("Zones at your location:").append(System.lineSeparator()).append(this.messenger.getBullets(names.toArray(new String[0]))).create(), (CommandSender)sender);
                }
                return;
            }
            String id = input[0].toString();
            Zone zone2 = this.api.getZone(id);
            if (zone2 == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            ArrayList<String> players = new ArrayList<String>();
            for (UUID uUID : zone2.getAllowedPlayers()) {
                players.add(Bukkit.getOfflinePlayer((UUID)uUID).getName());
            }
            ArrayList<String> flags = new ArrayList<String>();
            for (String flag : zone2.getFlags()) {
                flags.add(this.convertCase(flag));
            }
            BaseComponent[] baseComponentArray = zone2.getDescription() == null ? new ComponentBuilder("").create() : new ComponentBuilder(System.lineSeparator()).append(TextComponent.fromLegacyText((String)zone2.getDescription(), (ChatColor)ChatColor.GRAY)).create();
            this.messenger.sendMessage(new ComponentBuilder("Zone Info: ").color(ChatColor.GRAY).append(zone2.getName()).color(ChatColor.LIGHT_PURPLE).append(baseComponentArray).append(System.lineSeparator()).reset().append(System.lineSeparator()).append("Allowed Players:").color(ChatColor.WHITE).append(System.lineSeparator()).append(String.join((CharSequence)", ", players)).color(ChatColor.GRAY).append(System.lineSeparator()).reset().append(System.lineSeparator()).append("Active Flags:").color(ChatColor.WHITE).append(System.lineSeparator()).append(String.join((CharSequence)", ", flags)).color(ChatColor.GRAY).create(), (CommandSender)sender);
        }, new ArgZone().setRequired(false))).arg("list", (S sender) -> {
            if (this.api.getZoneKeys().isEmpty()) {
                this.messenger.sendMessage("No zones have been defined.", (CommandSender)sender);
            } else {
                ComponentBuilder builder = new ComponentBuilder("Defined Zones:");
                for (NamespacedKey key : this.api.getZoneKeys()) {
                    builder.append(System.lineSeparator()).reset().append(" - ").color(ChatColor.DARK_GRAY).append(this.convertCase(key.getKey())).color(ChatColor.GRAY).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zone info " + key.toString()));
                }
                this.messenger.sendMessage(builder.create(), (CommandSender)sender);
            }
        }, this.arg((S sender, Object[] input) -> {
            List<Zone> zones = this.api.getZones();
            zones.removeIf(zone -> !zone.canEdit(((OfflinePlayer)input[0]).getUniqueId()));
            if (zones.isEmpty()) {
                this.messenger.sendMessage("No zones have been defined.", (CommandSender)sender);
            } else {
                ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
                for (Zone zone2 : zones) {
                    keys.add(zone2.getKey());
                }
                ComponentBuilder builder = new ComponentBuilder("Zones Editable by " + ((OfflinePlayer)input[0]).getName() + ":");
                for (NamespacedKey key : keys) {
                    builder.append(System.lineSeparator()).reset().append(" - ").color(ChatColor.DARK_GRAY).append(this.convertCase(key.getKey())).color(ChatColor.GRAY).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zone info " + key.toString()));
                }
                this.messenger.sendMessage(builder.create(), (CommandSender)sender);
            }
        }, new ArgOfflinePlayer())).arg("remove", (S sender) -> this.messenger.sendMessage("/zone remove <zone_id> <player/uuid>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            String id = (String)input[0];
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            if (!zone.canEdit(sender instanceof Player ? ((Player)sender).getUniqueId() : UUID.randomUUID())) {
                this.messenger.sendMessage("You may not edit this zone.", (CommandSender)sender);
                return;
            }
            OfflinePlayer player = (OfflinePlayer)input[1];
            if (!zone.isAllowed(player.getUniqueId())) {
                this.messenger.sendMessage("This player was not added.", (CommandSender)sender);
            } else {
                zone.removePlayer(player.getUniqueId());
                this.messenger.sendMessage("Removed a player from this zone.", (CommandSender)sender);
            }
            this.api.updateCache();
        }, new Argument[]{new ArgZone(), new ArgPlayer()})).arg("show", (S sender) -> {
            if (!(sender instanceof Player)) {
                return;
            }
            List<Zone> zones = this.api.getZones(((Player)sender).getLocation().getBlock().getLocation());
            if (zones.isEmpty()) {
                this.messenger.sendMessage("No zones can be found at your location.", (CommandSender)sender);
                return;
            }
            zones.forEach(zone -> {
                if (zone instanceof CuboidalZone) {
                    ((CuboidalZone)zone).showBounds();
                } else if (zone instanceof PolyhedralZone) {
                    ((PolyhedralZone)zone).showBounds();
                }
            });
        }, this.arg((S sender, Object[] input) -> {
            String id = input[0].toString();
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            if (zone instanceof CuboidalZone) {
                ((CuboidalZone)zone).showBounds();
            } else if (zone instanceof PolyhedralZone) {
                ((PolyhedralZone)zone).showBounds();
            }
        }, new ArgZone())).arg("teleport", (S sender) -> this.messenger.sendMessage("You do not have permission for this action.", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            if (!(sender instanceof Player)) {
                return;
            }
            if (!sender.hasPermission("guardian.command.teleport")) {
                this.messenger.sendMessage("You do not have permission for this action.", (CommandSender)sender);
                return;
            }
            Player player = (Player)sender;
            String id = input[0].toString();
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            player.teleport(zone.getLocation());
            this.messenger.sendMessage("Teleporting to '" + zone.getName() + "'.", (CommandSender)sender);
        }, new ArgZone())).arg("toggle", (S sender) -> this.messenger.sendMessage("/zone toggle <zone_id> <flag>", (CommandSender)sender), this.arg((S sender, Object[] input) -> {
            String id = input[0].toString();
            String flag = input[1].toString();
            Zone zone = this.api.getZone(id);
            if (zone == null) {
                this.messenger.sendMessage("No zone with the id '" + id + "' can be found.", (CommandSender)sender);
                return;
            }
            if (!this.api.isProtectionFlag(flag)) {
                this.messenger.sendMessage("No flag with the id '" + id + "' is registered.", (CommandSender)sender);
                return;
            }
            if (!zone.canEdit(sender instanceof Player ? ((Player)sender).getUniqueId() : UUID.randomUUID())) {
                this.messenger.sendMessage("You may not edit this zone.", (CommandSender)sender);
                return;
            }
            if (!sender.hasPermission("guardian.flag." + id)) {
                this.messenger.sendMessage("You do not have permission to toggle this flag.", (CommandSender)sender);
                return;
            }
            if (zone.hasFlag(flag)) {
                zone.removeFlag(flag);
                this.messenger.sendMessage("Deactivated this flag for the specified zone.", (CommandSender)sender);
            } else {
                zone.addFlag(flag);
                this.messenger.sendMessage(new ComponentBuilder("Activated this flag for the specified zone. ").append("(Flags are blocking - active flags override default behaviour.)").color(ChatColor.GRAY).create(), (CommandSender)sender);
            }
            this.api.updateCache();
        }, new ArgZone(), new ArgFlag()));
    }

    @Override
    @NotNull
    public Consumer<CommandSender> getDefault() {
        return sender -> this.messenger.sendMessage(this.api.getCommandHelpMessage(this), (CommandSender)sender);
    }

    private String convertCase(String string) {
        String[] words = string.split("_");
        ArrayList<String> list = new ArrayList<String>();
        for (String word : words) {
            list.add(word.isEmpty() ? word : Ascii.toUpperCase((char)word.charAt(0)) + Ascii.toLowerCase((String)word.substring(1)));
        }
        return String.join((CharSequence)" ", list);
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return Arrays.asList("gz", "gzone", "guardianzone", "region");
    }

    @Override
    @NotNull
    public String getUsage() {
        return "/zone help";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Used for managing protection zones.";
    }

    @Override
    @Nullable
    public String getPermission() {
        return "guardian.command.zone";
    }

    @Override
    @Nullable
    public String getPermissionMessage() {
        return null;
    }

    @Override
    @Nullable
    public List<String> getCompletions(int i) {
        return null;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.execute(sender, args);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.api.getTabCompletions(this, args);
    }
}

