/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.command;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.mask.command.Commander;
import com.moderocky.guardian.mask.template.WrappedCommand;
import com.moderocky.guardian.util.Messenger;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WandCommand
extends Commander<Player>
implements WrappedCommand {
    @NotNull
    private final GuardianConfig config = Guardian.getInstance().getGuardianConfig();
    @NotNull
    private final Messenger messenger = Guardian.getMessenger();

    @Override
    @NotNull
    public List<String> getAliases() {
        return Arrays.asList("gwand", "guardianwand");
    }

    @Override
    @NotNull
    public String getUsage() {
        return "/" + this.getCommand();
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Obtain a guardian wand.";
    }

    @Override
    @Nullable
    public String getPermission() {
        return "guardian.command." + this.getCommand();
    }

    @Override
    @Nullable
    public String getPermissionMessage() {
        return null;
    }

    @Override
    @NotNull
    public Commander.Main create() {
        return this.command("wand");
    }

    @Override
    @NotNull
    public Consumer<Player> getDefault() {
        return player -> {
            PlayerInventory inventory = player.getInventory();
            if (inventory.getItemInMainHand().getType() == Material.AIR) {
                inventory.setItemInMainHand(this.config.getWand());
            } else {
                inventory.addItem(new ItemStack[]{this.config.getWand()});
            }
            this.messenger.sendMessage("You have received a wand. Use this to select points!", new CommandSender[]{player});
        };
    }

    @Override
    @NotNull
    public String getCommand() {
        return "wand";
    }

    @Override
    @Nullable
    public List<String> getCompletions(int i) {
        return null;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        return this.execute((Player)sender, args);
    }
}

