/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.command;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.mask.command.Commander;
import com.moderocky.guardian.mask.template.WrappedCommand;
import com.moderocky.guardian.util.Messenger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuardianCommand
extends Commander<CommandSender>
implements WrappedCommand {
    public static GuardianCommand command;
    @NotNull
    private final GuardianConfig config = Guardian.getInstance().getGuardianConfig();
    @NotNull
    private final Messenger messenger = Guardian.getMessenger();
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    public GuardianCommand() {
        command = this;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return Arrays.asList("g", "guard");
    }

    @Override
    @NotNull
    public String getUsage() {
        return "/" + this.getCommand();
    }

    @Override
    @NotNull
    public String getDescription() {
        return "The main command for Guardian.";
    }

    @Override
    @Nullable
    public String getPermission() {
        return "guardian.command." + this.getCommand();
    }

    @Override
    @Nullable
    public String getPermissionMessage() {
        return null;
    }

    @Override
    @NotNull
    public Commander.Main create() {
        return this.command("guardian").arg("flags", (S sender) -> {
            ComponentBuilder builder = new ComponentBuilder("List of Flags:").color(ChatColor.WHITE);
            for (BaseComponent[] flag : new MagicList<String>((Collection<String>)this.api.getProtectionFlags()).collect(string -> TextComponent.fromLegacyText((String)string, (ChatColor)ChatColor.GRAY))) {
                builder.append(System.lineSeparator()).append(flag);
            }
            this.messenger.sendMessage(builder.create(), new CommandSender[0]);
        }).arg("about", (S sender) -> this.messenger.sendMessage(new ComponentBuilder("").color(ChatColor.WHITE).append("Guardian").color(ChatColor.AQUA).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Visit the website?"))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Moderocky/Guardian")).append(" v" + Guardian.getInstance().getVersion()).append(" by ").append("@Moderocky").color(ChatColor.AQUA).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Discord: Moderocky#0001\nGitLab: Moderocky\nGithub: Moderocky\nSpigot: Moderocky"))).event(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "Moderocky#0001")).append(System.lineSeparator()).reset().color(ChatColor.WHITE).append("A lightweight zones/regions system, designed to be easy-to-use and easy for developers to access. ").color(ChatColor.GRAY).append(System.lineSeparator()).append("New to Guardian? Click ").color(ChatColor.GRAY).append("here").color(ChatColor.AQUA).underlined(true).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Getting started guide?"))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Moderocky/Guardian/-/wikis/Creating-Zones")).append(" ").reset().color(ChatColor.GRAY).underlined(false).append("for a tutorial.").color(ChatColor.GRAY).color(ChatColor.GRAY).append(System.lineSeparator()).append("If you are interested in developing a Guardian addon, click ").color(ChatColor.GRAY).append("here").color(ChatColor.AQUA).underlined(true).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Learn about addon development?"))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Moderocky/Guardian/-/wikis/Addon-Creation")).append(" ").reset().color(ChatColor.GRAY).underlined(false).append("for information.").color(ChatColor.GRAY).color(ChatColor.GRAY).append(System.lineSeparator()).append("Built on the ").color(ChatColor.GRAY).italic(true).append("Mask").color(ChatColor.GOLD).italic(true).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Mask Framework?"))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Pandaemonium/Mask")).append(" framework.").color(ChatColor.GRAY).italic(true).create(), (CommandSender)sender)).arg("update", (S sender) -> this.messenger.sendMessage(new ComponentBuilder().append("This function is not currently supported.").append(System.lineSeparator()).append("You can manually download the latest version ").append("here").color(ChatColor.AQUA).underlined(true).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Guardian Repository"))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Moderocky/Guardian/-/tags")).append(".").retain(ComponentBuilder.FormatRetention.NONE).reset().create(), (CommandSender)sender)).arg("reload", (S sender) -> {
            Guardian.getInstance().getGuardianConfig().load();
            this.messenger.sendMessage(new ComponentBuilder().append("Guardian config reloaded.").create(), (CommandSender)sender);
        }).arg("wiki", (S sender) -> this.messenger.sendMessage(new ComponentBuilder().append("Click ").color(ChatColor.WHITE).underlined(false).append("here").color(ChatColor.AQUA).underlined(true).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"Click to open the Guardian wiki."))).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://gitlab.com/Moderocky/Guardian/-/wikis/home")).append(" ").reset().color(ChatColor.WHITE).underlined(false).append("for the wiki.").color(ChatColor.WHITE).create(), (CommandSender)sender));
    }

    @Override
    @NotNull
    public Consumer<CommandSender> getDefault() {
        return sender -> this.messenger.sendMessage(this.api.getCommandHelpMessage(this), (CommandSender)sender);
    }

    @Override
    @Nullable
    public List<String> getCompletions(int i, @NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.api.getTabCompletions(this, args);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.execute(sender, args);
    }
}

