/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian;

import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.bstats.bukkit.Metrics;
import com.moderocky.guardian.command.GuardianCommand;
import com.moderocky.guardian.command.PolywandCommand;
import com.moderocky.guardian.command.WandCommand;
import com.moderocky.guardian.command.ZoneCommand;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.listener.AsyncPlayerChatListener;
import com.moderocky.guardian.listener.BlockBreakListener;
import com.moderocky.guardian.listener.BlockPlaceListener;
import com.moderocky.guardian.listener.EntityDamageByEntityListener;
import com.moderocky.guardian.listener.EntityExplodeListener;
import com.moderocky.guardian.listener.EntitySpawnListener;
import com.moderocky.guardian.listener.InventoryOpenListener;
import com.moderocky.guardian.listener.PlayerAttemptPickupItemListener;
import com.moderocky.guardian.listener.PlayerCommandPreprocessListener;
import com.moderocky.guardian.listener.PlayerInteractEntityListener;
import com.moderocky.guardian.listener.PlayerInteractListener;
import com.moderocky.guardian.listener.PlayerMoveListener;
import com.moderocky.guardian.listener.PlayerTeleportListener;
import com.moderocky.guardian.mask.template.BukkitPlugin;
import com.moderocky.guardian.util.Messenger;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Guardian
extends BukkitPlugin {
    private static GuardianAPI api;
    private static Guardian instance;
    private static Messenger messenger;
    @NotNull
    private final GuardianConfig config = new GuardianConfig();
    @NotNull
    private final Metrics metrics = new Metrics((Plugin)this, 7168);

    public static Guardian getInstance() {
        return instance;
    }

    public static Messenger getMessenger() {
        return messenger;
    }

    public static GuardianAPI getApi() {
        return api;
    }

    @Override
    public void startup() {
        instance = this;
        messenger = new Messenger(this);
        api = new GuardianAPI();
        api.init();
        this.registerPermissions();
    }

    @Override
    public void disable() {
        api.save();
        instance = null;
        messenger = null;
        api = null;
    }

    private void registerPermissions() {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(new Permission("guardian.command.guardian", "Guardian command permission.", PermissionDefault.TRUE, null));
        permissions.add(new Permission("guardian.command.wand", "Wand command permission.", PermissionDefault.OP, null));
        permissions.add(new Permission("guardian.command.polywand", "Polywand command permission.", PermissionDefault.OP, null));
        permissions.add(new Permission("guardian.command.zone", "Zone command permission.", PermissionDefault.OP, null));
        permissions.add(new Permission("guardian.command.teleport", "Zone teleport permission.", PermissionDefault.OP, null));
        permissions.add(new Permission("guardian.zone.allow_oversized", "Oversized zone permission.", PermissionDefault.OP, null));
        permissions.forEach(permission -> Bukkit.getPluginManager().addPermission(permission));
    }

    @Override
    protected void registerListeners() {
        this.register(new AsyncPlayerChatListener(), new BlockBreakListener(), new BlockPlaceListener(), new EntityDamageByEntityListener(), new EntityExplodeListener(), new EntitySpawnListener(), new InventoryOpenListener(), new PlayerAttemptPickupItemListener(), new PlayerCommandPreprocessListener(), new PlayerInteractEntityListener(), new PlayerInteractListener(), new PlayerTeleportListener());
        if (this.config.checkEntryExit) {
            this.register(new PlayerMoveListener());
        }
    }

    @Override
    protected void registerCommands() {
        this.register(new GuardianCommand(), new WandCommand(), new PolywandCommand(), new ZoneCommand());
    }

    @Override
    protected void registerSyntax() {
        try {
            this.getAddon().loadClasses("com.moderocky.guardian.skript", new String[]{"condition"});
            this.getAddon().loadClasses("com.moderocky.guardian.skript", new String[]{"effect"});
            this.getAddon().loadClasses("com.moderocky.guardian.skript", new String[]{"expression"});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public Metrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public GuardianConfig getGuardianConfig() {
        return this.config;
    }
}

