/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import me.limeglass.funky.lang.FunkyExpression;
import me.limeglass.funky.utils.annotations.Patterns;
import org.bukkit.event.Event;

@Name(value="File songs")
@Description(value={"Returns all the .nbs songs in a file location."})
@Patterns(value={"[(all [[of] the]|the)] [nbt] song[s] [file[s]] in [the] (directory|file[s]) %string%"})
public class ExprSongsInFile
extends FunkyExpression<String> {
    protected String[] get(Event event) {
        if (this.areNull(event)) {
            return null;
        }
        ArrayList<String> songs = new ArrayList<String>();
        File directory = new File(this.expressions.getSingle(event, String.class));
        if (!directory.isDirectory()) {
            return null;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String extension;
                return name.lastIndexOf(46) > 0 && (extension = name.substring(name.lastIndexOf(46))).equals(".nbs");
            }
        };
        for (File file : directory.listFiles(filter)) {
            songs.add(file.getName());
        }
        if (songs == null || songs.isEmpty()) {
            return null;
        }
        return songs.toArray(new String[songs.size()]);
    }
}

