/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import me.limeglass.funky.lang.FunkyPropertyExpression;
import me.limeglass.funky.utils.annotations.Changers;
import me.limeglass.funky.utils.annotations.Properties;
import me.limeglass.funky.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Song player tick")
@Description(value={"Returns the tick that the song player(s) are currently on."})
@Properties(value={"funkysongplayers", "[playing] tick[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="song[ ]player[s]")
@Changers(value={Changer.ChangeMode.SET})
public class ExprSongPlayerTick
extends FunkyPropertyExpression<SongPlayer, Number> {
    protected Number[] get(Event event, SongPlayer[] songPlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Short> ticks = new ArrayList<Short>();
        for (SongPlayer songPlayer : songPlayers) {
            ticks.add(songPlayer.getTick());
        }
        return ticks.toArray(new Number[ticks.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        for (SongPlayer songPlayer : this.expressions.getAll(event, SongPlayer.class)) {
            songPlayer.setTick(((Number)delta[0]).shortValue());
        }
    }
}

