/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import java.util.Objects;
import me.limeglass.funky.lang.FunkyPropertyExpression;
import me.limeglass.funky.utils.annotations.AllChangers;
import me.limeglass.funky.utils.annotations.Properties;
import me.limeglass.funky.utils.annotations.PropertiesAddition;
import me.limeglass.funky.utils.annotations.Settable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Song player users")
@Description(value={"Returns the listeners of the song player(s)."})
@Properties(value={"funkysongplayers", "(player|listener)[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="song[ ]player[s]")
@AllChangers
@Settable(value={Player[].class, String[].class})
public class ExprSongPlayerListeners
extends FunkyPropertyExpression<SongPlayer, Player> {
    protected Player[] get(Event event, SongPlayer[] songPlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (SongPlayer songPlayer : songPlayers) {
            for (String player : songPlayer.getPlayerList()) {
                players.add(Bukkit.getPlayer((String)player));
            }
        }
        if (players == null || players.isEmpty()) {
            return null;
        }
        return players.toArray(new Player[players.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        switch (mode) {
            case ADD: {
                for (SongPlayer songPlayer : this.expressions.getAll(event, SongPlayer.class)) {
                    for (Object object : delta) {
                        if (object instanceof String && !songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.addPlayer(Bukkit.getPlayer((String)((String)object)));
                            continue;
                        }
                        if (object instanceof Player && !songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.addPlayer((Player)object);
                            continue;
                        }
                        Skript.error((String)("That was an unsupported value for removeing of Players within an ID: " + Objects.toString(object)));
                    }
                }
                break;
            }
            case REMOVE: {
                for (SongPlayer songPlayer : this.expressions.getAll(event, SongPlayer.class)) {
                    for (Object object : delta) {
                        if (object instanceof String && songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.removePlayer(Bukkit.getPlayer((String)((String)object)));
                            continue;
                        }
                        if (object instanceof Player && songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.removePlayer((Player)object);
                            continue;
                        }
                        Skript.error((String)("That was an unsupported value for removal of Players within an ID: " + Objects.toString(object)));
                    }
                }
                break;
            }
            case SET: {
                super.change(event, delta, Changer.ChangeMode.DELETE);
                super.change(event, delta, Changer.ChangeMode.ADD);
                break;
            }
            case REMOVE_ALL: 
            case RESET: 
            case DELETE: {
                for (SongPlayer songPlayer : this.expressions.getAll(event, SongPlayer.class)) {
                    for (String player : songPlayer.getPlayerList()) {
                        songPlayer.removePlayer(Bukkit.getPlayer((String)player));
                    }
                }
                break;
            }
        }
    }
}

