/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import me.limeglass.funky.lang.FunkyPropertyExpression;
import me.limeglass.funky.utils.annotations.Changers;
import me.limeglass.funky.utils.annotations.Properties;
import me.limeglass.funky.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Song fade finish")
@Description(value={"Returns the fade finishing time of the song player(s)."})
@Properties(value={"funkysongplayers", "fad(e|ing)[ ]((finish|end)[ing]|done) [time][s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="[song[ ]player[s]]")
@Changers(value={Changer.ChangeMode.SET})
public class ExprSongPlayerFadeFinish
extends FunkyPropertyExpression<SongPlayer, Number> {
    protected Number[] get(Event event, SongPlayer[] songPlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Integer> fades = new ArrayList<Integer>();
        for (SongPlayer songPlayer : songPlayers) {
            fades.add(songPlayer.getFadeDone());
        }
        return fades.toArray(new Number[fades.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        for (SongPlayer songPlayer : this.expressions.getAll(event, SongPlayer.class)) {
            songPlayer.setFadeDone(((Number)delta[0]).intValue());
        }
    }
}

