/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.PositionSongPlayer;
import java.util.ArrayList;
import me.limeglass.funky.lang.FunkyPropertyExpression;
import me.limeglass.funky.utils.annotations.Changers;
import me.limeglass.funky.utils.annotations.Properties;
import me.limeglass.funky.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Position player distance")
@Description(value={"Returns the distance that the position song player(s) can be heard from. The default distance is 16."})
@Properties(value={"positionsongplayers", "[sound] (distance|range)[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="position song[ ]player[s]")
@Changers(value={Changer.ChangeMode.SET})
public class ExprPositionSongPlayerDistance
extends FunkyPropertyExpression<PositionSongPlayer, Number> {
    protected Number[] get(Event event, PositionSongPlayer[] songPlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        for (PositionSongPlayer songPlayer : songPlayers) {
            ranges.add(songPlayer.getDistance());
        }
        return ranges.toArray(new Number[ranges.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        for (PositionSongPlayer songPlayer : this.expressions.getAll(event, PositionSongPlayer.class)) {
            songPlayer.setDistance(((Number)delta[0]).intValue());
        }
    }
}

