/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.ID;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import java.util.Objects;
import me.limeglass.funky.lang.FunkyExpression;
import me.limeglass.funky.utils.MusicManager;
import me.limeglass.funky.utils.annotations.AllChangers;
import me.limeglass.funky.utils.annotations.DetermineSingle;
import me.limeglass.funky.utils.annotations.Patterns;
import me.limeglass.funky.utils.annotations.Settable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="ID - Song players")
@Description(value={"Returns the players currently listening to a song with an ID. Returns as a string because that's what NoteBlockAPI does."})
@Patterns(value={"[(all [[of] the]|the)] player[s] (in|listening to) song with id[s] %strings%"})
@DetermineSingle
@AllChangers
@Settable(value={Player[].class, String[].class})
public class ExprPlayersInID
extends FunkyExpression<String> {
    protected String[] get(Event event) {
        if (this.areNull(event)) {
            return null;
        }
        ArrayList players = new ArrayList();
        for (String song : this.expressions.getAll(event, String.class)) {
            players.addAll(MusicManager.getSongPlayer(song).getPlayerList());
        }
        if (players == null || players.isEmpty()) {
            return null;
        }
        return players.toArray(new String[players.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.areNull(event) || delta == null) {
            return;
        }
        ArrayList<SongPlayer> songPlayers = new ArrayList<SongPlayer>();
        for (String song : this.expressions.getAll(event, String.class)) {
            songPlayers.add(MusicManager.getSongPlayer(song));
        }
        switch (mode) {
            case ADD: {
                for (SongPlayer songPlayer : songPlayers) {
                    for (Object object : delta) {
                        if (object instanceof String && !songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.addPlayer(Bukkit.getPlayer((String)((String)object)));
                            continue;
                        }
                        if (object instanceof Player && !songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.addPlayer((Player)object);
                            continue;
                        }
                        Skript.error((String)("That was an unsupported value for removeing of Players within an ID: " + Objects.toString(object)));
                    }
                }
                break;
            }
            case REMOVE: {
                for (SongPlayer songPlayer : songPlayers) {
                    for (Object object : delta) {
                        if (object instanceof String && songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.removePlayer(Bukkit.getPlayer((String)((String)object)));
                            continue;
                        }
                        if (object instanceof Player && songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.removePlayer((Player)object);
                            continue;
                        }
                        Skript.error((String)("That was an unsupported value for removal of Players within an ID: " + Objects.toString(object)));
                    }
                }
                break;
            }
            case SET: {
                super.change(event, delta, Changer.ChangeMode.DELETE);
                super.change(event, delta, Changer.ChangeMode.ADD);
                break;
            }
            case REMOVE_ALL: 
            case RESET: 
            case DELETE: {
                for (SongPlayer songPlayer : songPlayers) {
                    for (String player : songPlayer.getPlayerList()) {
                        songPlayer.removePlayer(Bukkit.getPlayer((String)player));
                    }
                }
                break;
            }
        }
    }
}

