/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.InventorySlot;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Inventory Slot")
@Description(value={"Represents a slot in a inventory. It can be used to change the item in a inventory too."})
@Examples(value={"if slot 0 of player is air:", "\tset slot 0 of player to 2 stones", "\tremove 1 stone from slot 0 of player", "\tadd 2 stones to slot 0 of player", "\tclear slot 1 of player"})
@Since(value="2.2-dev24")
public class ExprInventorySlot
extends SimpleExpression<Slot> {
    private Expression<Number> slots;
    private Expression<Inventory> invis;

    static {
        Skript.registerExpression(ExprInventorySlot.class, Slot.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] slot[s] %numbers% of %inventory%", "%inventory%['s] slot[s] %numbers%"});
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.slots = exprs[0];
            this.invis = exprs[1];
        } else {
            this.slots = exprs[1];
            this.invis = exprs[0];
        }
        return true;
    }

    protected @Nullable Slot[] get(Event event) {
        Inventory inventory = (Inventory)this.invis.getSingle(event);
        Number[] inventorySlots = (Number[])this.slots.getAll(event);
        if (inventorySlots == null || inventory == null || inventorySlots.length < 1) {
            return null;
        }
        ArrayList<InventorySlot> slots = new ArrayList<InventorySlot>();
        Number[] numberArray = inventorySlots;
        int n = inventorySlots.length;
        int n2 = 0;
        while (n2 < n) {
            Number slot = numberArray[n2];
            if (slot.intValue() >= 0 && slot.intValue() < inventory.getSize()) {
                slots.add(new InventorySlot(inventory, slot.intValue()));
            }
            ++n2;
        }
        if (slots == null || slots.isEmpty()) {
            return null;
        }
        return slots.toArray(new Slot[slots.size()]);
    }

    public boolean isSingle() {
        return this.slots.isSingle();
    }

    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "slots " + this.slots.toString(e, debug) + " of " + this.invis.toString(e, debug);
    }
}

