/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.Layer;
import com.xxmicloxx.NoteBlockAPI.Note;
import java.util.ArrayList;
import me.limeglass.funky.lang.FunkyExpression;
import me.limeglass.funky.utils.annotations.Changers;
import me.limeglass.funky.utils.annotations.DetermineSingle;
import me.limeglass.funky.utils.annotations.Patterns;
import me.limeglass.funky.utils.annotations.RegisterType;
import org.bukkit.event.Event;

@Name(value="Layer notes")
@Description(value={"Returns a note at the defined tick of the song."})
@Patterns(value={"[(all [[of] the]|the)] note[s] of [layer[s]] %layers% [at [tick] %-number%]", "[layer[s]] %layers%['s] note[s] [at [tick] %-number%]"})
@RegisterType(value="note")
@DetermineSingle
@Changers(value={Changer.ChangeMode.SET})
public class ExprLayerNote
extends FunkyExpression<Note> {
    protected Note[] get(Event event) {
        if (this.isNull(event, Layer.class).booleanValue()) {
            return null;
        }
        Number tick = this.expressions.getSingle(event, Number.class);
        ArrayList<Object> notes = new ArrayList<Object>();
        Layer[] layerArray = this.expressions.getAll(event, Layer.class);
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            if (!this.isNull(event, Number.class).booleanValue()) {
                notes.add(layer.getNote(tick.intValue()));
            } else {
                notes.addAll(layer.getHashMap().values());
            }
            ++n2;
        }
        if (notes == null || notes.isEmpty()) {
            return null;
        }
        return notes.toArray(new Note[notes.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.areNull(event).booleanValue() || delta == null) {
            Skript.error((String)"You can't have the tick number null when attempting to set the notes");
            return;
        }
        if (!this.expressions.getExpressions()[0].isSingle()) {
            Skript.error((String)"You can only set one layer at a time when setting the expression: ExprLayerNote.");
            return;
        }
        int tick = this.expressions.getSingle(event, Number.class).intValue();
        this.expressions.getSingle(event, Layer.class).setNote(tick, (Note)delta[0]);
    }
}

