/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.funky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import java.util.Objects;
import me.limeglass.funky.lang.FunkyPropertyExpression;
import me.limeglass.funky.utils.annotations.AllChangers;
import me.limeglass.funky.utils.annotations.Properties;
import me.limeglass.funky.utils.annotations.PropertiesAddition;
import me.limeglass.funky.utils.annotations.Settable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Song player users")
@Description(value={"Returns the listeners of the song player(s)."})
@Properties(value={"songplayers", "(player|listener)[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="song[ ]player[s]")
@AllChangers
@Settable(value={Player[].class, String[].class})
public class ExprSongPlayerListeners
extends FunkyPropertyExpression<SongPlayer, Player> {
    protected Player[] get(Event event, SongPlayer[] songPlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList players = new ArrayList();
        SongPlayer[] songPlayerArray = songPlayers;
        int n = songPlayers.length;
        int n2 = 0;
        while (n2 < n) {
            SongPlayer songPlayer = songPlayerArray[n2];
            players.addAll(songPlayer.getPlayerList());
            ++n2;
        }
        return players.toArray(new Player[players.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        switch (mode) {
            case ADD: {
                SongPlayer[] songPlayerArray = this.expressions.getAll(event, SongPlayer.class);
                int n = songPlayerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SongPlayer songPlayer = songPlayerArray[n2];
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        if (object instanceof String && !songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.addPlayer(Bukkit.getPlayer((String)((String)object)));
                        } else if (object instanceof Player && !songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.addPlayer((Player)object);
                        } else {
                            Skript.error((String)("That was an unsupported value for removeing of Players within an ID: " + Objects.toString(object)));
                        }
                        ++n4;
                    }
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                SongPlayer[] songPlayerArray = this.expressions.getAll(event, SongPlayer.class);
                int n = songPlayerArray.length;
                int n5 = 0;
                while (n5 < n) {
                    SongPlayer songPlayer = songPlayerArray[n5];
                    Object[] objectArray = delta;
                    int n6 = delta.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Object object = objectArray[n7];
                        if (object instanceof String && songPlayer.getPlayerList().contains((String)object)) {
                            songPlayer.removePlayer(Bukkit.getPlayer((String)((String)object)));
                        } else if (object instanceof Player && songPlayer.getPlayerList().contains(((Player)object).getName())) {
                            songPlayer.removePlayer((Player)object);
                        } else {
                            Skript.error((String)("That was an unsupported value for removal of Players within an ID: " + Objects.toString(object)));
                        }
                        ++n7;
                    }
                    ++n5;
                }
                break;
            }
            case SET: {
                super.change(event, delta, Changer.ChangeMode.DELETE);
                super.change(event, delta, Changer.ChangeMode.ADD);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                SongPlayer[] songPlayerArray = this.expressions.getAll(event, SongPlayer.class);
                int n = songPlayerArray.length;
                int n8 = 0;
                while (n8 < n) {
                    SongPlayer songPlayer = songPlayerArray[n8];
                    for (String player : songPlayer.getPlayerList()) {
                        songPlayer.removePlayer(Bukkit.getPlayer((String)player));
                    }
                    ++n8;
                }
                break;
            }
        }
    }
}

