/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.util.Direction;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import me.limeglass.fawesk.lang.FaweskExpression;
import me.limeglass.fawesk.utils.annotations.Patterns;
import me.limeglass.fawesk.utils.annotations.RegisterType;
import me.limeglass.fawesk.utils.annotations.Single;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Fawesk - Cuboid region")
@Description(value={"Returns the CuboidRegion between two locations. This is also defined as a worldeditregion."})
@Patterns(value={"[fawe[sk]] (world[ ]edit|cuboid)[[ ]region] from %location% [(to [the]|on|towards)] %direction/location%", "[fawe[sk]] (world[ ]edit|cuboid)[[ ]region] (within|between|from) %block% (and|to) %block%"})
@RegisterType(value="cuboidregion")
@Single
public class ExprCuboidRegion
extends FaweskExpression<CuboidRegion> {
    protected CuboidRegion[] get(Event event) {
        if (this.areNull(event).booleanValue()) {
            return null;
        }
        Object from = this.expressions.get(0).getSingle(event);
        Object to = this.expressions.get(1).getSingle(event);
        Location fromLoc = from instanceof Block ? ((Block)from).getLocation() : (Location)from;
        Vector fromVector = new Vector(fromLoc.getX(), fromLoc.getY(), fromLoc.getZ());
        LocalWorld world = BukkitUtil.getLocalWorld((org.bukkit.World)fromLoc.getWorld());
        Location toLoc = to instanceof Block ? ((Block)to).getLocation() : (to instanceof Location ? (Location)to : ((Direction)to).getDirection(fromLoc).toLocation(fromLoc.getWorld()));
        Vector toVector = new Vector(toLoc.getX(), toLoc.getY(), toLoc.getZ());
        return new CuboidRegion[]{new CuboidRegion((World)world, fromVector, toVector)};
    }
}

