/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import me.limeglass.fawesk.lang.FaweskEffect;
import me.limeglass.fawesk.utils.annotations.Patterns;
import org.bukkit.event.Event;

@Name(value="Fawesk - Cuboid biome")
@Description(value={"Changes the biomes of the Cuboid region(s)"})
@Patterns(value={"change biome of [the] [cuboid[[ ]region][s]] %cuboidregions% to [biome] %string%"})
public class EffCuboidRegionBiome
extends FaweskEffect {
    protected void execute(Event event) {
        if (this.areNull(event).booleanValue()) {
            return;
        }
        String input = this.expressions.getSingle(event, String.class);
        CuboidRegion[] cuboidRegionArray = this.expressions.getAll(event, CuboidRegion.class);
        int n = cuboidRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidRegion cuboid = cuboidRegionArray[n2];
            World world = cuboid.getWorld();
            BiomeRegistry registry = world.getWorldData().getBiomeRegistry();
            EditSession session = FaweAPI.getEditSessionBuilder((World)world).autoQueue(Boolean.valueOf(true)).build();
            BaseBiome biome = null;
            for (BaseBiome baseBiome : registry.getBiomes()) {
                if (!registry.getData(baseBiome).getName().equalsIgnoreCase(input)) continue;
                biome = baseBiome;
                break;
            }
            if (biome != null) {
                BiomeReplace function = new BiomeReplace((Extent)session, biome);
                FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion((Region)cuboid), (FlatRegionFunction)function);
                try {
                    Operations.completeLegacy((Operation)visitor);
                }
                catch (MaxChangedBlocksException e) {
                    Skript.error((String)"The maximum amount of changed blocks has been exceeded.");
                }
            }
            ++n2;
        }
    }
}

