/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.time.utils;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.registrations.Classes;
import java.util.HashMap;
import me.limeglass.time.Time;
import me.limeglass.time.utils.LangEnumParser;
import org.eclipse.jdt.annotation.Nullable;

public class EnumClassInfo<E extends Enum<E>> {
    private final Class<E> enumType;
    private final ClassInfo<E> classInfo;
    private final String codeName;
    private final String user;
    private final HashMap<String, String> synonyms = new HashMap();

    private EnumClassInfo(Class<E> enumType, String codeName, @Nullable String user) {
        this.enumType = enumType;
        this.codeName = codeName;
        this.user = user;
        this.classInfo = new ClassInfo(enumType, codeName);
    }

    public static <E extends Enum<E>> EnumClassInfo<E> create(Class<E> enumType, String codeName, @Nullable String user) {
        if (user == null) {
            user = codeName + "s?";
        }
        return new EnumClassInfo(enumType, codeName, user);
    }

    public EnumClassInfo<E> addSynonym(String regex, String actualValue) {
        this.synonyms.put(regex, actualValue);
        return this;
    }

    public EnumClassInfo<E> after(String ... after) {
        this.classInfo.after(after);
        return this;
    }

    public EnumClassInfo<E> before(String ... before) {
        this.classInfo.before(before);
        return this;
    }

    public void register() {
        if (Classes.getExactClassInfo((Class)this.enumType) == null) {
            if (Time.getInstance().getConfig().getBoolean("UseEnglishEnums")) {
                Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{this.user}).parser((Parser)new LangEnumParser(this.codeName, this.enumType)).serializer((Serializer)new EnumSerializer(this.enumType)));
            } else {
                Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{this.user}).parser((Parser)new /* Unavailable Anonymous Inner Class!! */).serializer((Serializer)new EnumSerializer(this.enumType)));
                Time.getConfiguration((String)"syntax").set("Syntax.Enums." + this.enumType.getSimpleName() + ".enums", this.enumType.getEnumConstants());
            }
            this.enumDebug("&5Registered Enum '" + this.codeName + "' with return class " + this.enumType.getName(), this.codeName, this.enumType);
        }
    }

    private void enumDebug(String message, String codeName, Class<?> clazz) {
        if (codeName.equalsIgnoreCase(Time.getInstance().getConfig().getString("syntaxDebug"))) {
            Time.debugMessage((String)("&eRegistered syntaxDebug found enum classinfo: " + codeName + " (" + clazz.getCanonicalName() + ")"));
        } else {
            Time.debugMessage((String)("&5Registered Enum '" + codeName + "' with return class " + this.enumType.getName()));
        }
        Time.getConfiguration((String)"syntax").set("Syntax.Enums." + clazz.getSimpleName() + ".user", (Object)this.user);
        Time.save((String)"syntax");
    }

    static /* synthetic */ String access$000(EnumClassInfo x0) {
        return x0.codeName;
    }

    static /* synthetic */ HashMap access$100(EnumClassInfo x0) {
        return x0.synonyms;
    }

    static /* synthetic */ Class access$200(EnumClassInfo x0) {
        return x0.enumType;
    }
}

