/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.time.elements.datetime;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import java.time.Month;
import java.util.TimeZone;
import me.limeglass.time.lang.TimeExpression;
import me.limeglass.time.utils.TimeZones;
import me.limeglass.time.utils.annotations.Patterns;
import me.limeglass.time.utils.annotations.RegisterType;
import me.limeglass.time.utils.annotations.Single;
import org.bukkit.event.Event;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Name(value="DateTime - New date and time")
@Description(value={"Returns a new DateTime with optional parameters."})
@Examples(value={"set {_date} to todays date", "set {_date} to todays date in timezone us eastern", "set {_date} to a new date with year 1996, month july, day 26, 6 hours, and 56 minutes", "set {_date} to a new date with year 2005, month may, day 30, 1 hour, 90 minutes, 5 seconds, and 100 milliseconds"})
@Patterns(value={"[(todays|[a] [new])] date[( and time|time)][with [year] %-number%[(, | with)] [month] %-number/month%[(, | with)] [day] %-number%[(, | with)] %-number% [hour[s]][(, [and]| with)] %-number% [minute[s]]][[(, [and]| with)] %-number% [second[s]]][[(, [and]| with)] %-number% [milli[-]second[s]]][[[(, [and] | with)][in]] time[ ]zone %-timezone%]"})
@RegisterType(value="datetime")
@Single
public class ExprDateTime
extends TimeExpression<DateTime> {
    protected DateTime[] get(Event event) {
        DateTime date = new DateTime();
        if (!this.isNull(event, new int[]{7}).booleanValue()) {
            date = new DateTime(DateTimeZone.forTimeZone((TimeZone)((TimeZones)this.expressions.getSingle(event, TimeZones.class)).getTimeZone()));
        }
        if (!this.isNull(event, new int[]{0, 1, 2, 3, 4}).booleanValue()) {
            date = date.withYear(this.expressions.getInt(event, 0).intValue());
            Object month = this.expressions.get(1).getSingle(event);
            date = month instanceof Month ? date.withMonthOfYear(((Month)month).getValue()) : date.withMonthOfYear(((Integer)month).intValue());
            date = date.withDayOfMonth(this.expressions.getInt(event, 2).intValue()).withHourOfDay(this.expressions.getInt(event, 3).intValue()).withMinuteOfHour(this.expressions.getInt(event, 4).intValue());
        }
        if (!this.isNull(event, new int[]{5}).booleanValue()) {
            date = date.withSecondOfMinute(this.expressions.getInt(event, 5).intValue());
        }
        if (!this.isNull(event, new int[]{6}).booleanValue()) {
            date = date.withMillisOfSecond(this.expressions.getInt(event, 6).intValue());
        }
        return new DateTime[]{date};
    }
}

