/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.sk89q.worldedit.regions.Region;
import java.util.Set;
import me.limeglass.fawesk.lang.FaweskPropertyExpression;
import me.limeglass.fawesk.utils.annotations.Properties;
import me.limeglass.fawesk.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Fawesk - Worldedit region vectors")
@Description(value={"Returns either the center/max/min/chunks vector location(s) of the worldedit region(s)."})
@Properties(value={"worldeditregions", "(1\u00a6center|2\u00a6max[imum] [(point|pos[ition])]|3\u00a6min[imum] [(point|pos[ition])]|4\u00a6chunk [cube[s]])[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="(world[ ]edit|cuboid)[[ ]region[s]]")
public class ExprRegionVectors
extends FaweskPropertyExpression<Region, Vector> {
    protected Vector[] get(Event event, Region[] regions) {
        Region[] regionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            Region region = regionArray[n2];
            switch (this.patternMark) {
                case 1: {
                    this.add(region.getCenter());
                    break;
                }
                case 2: {
                    this.add(region.getMaximumPoint());
                    break;
                }
                case 3: {
                    this.add(region.getMinimumPoint());
                    break;
                }
                case 4: {
                    this.addAll(region.getChunkCubes());
                }
            }
            ++n2;
        }
        return this.collection.toArray(new Vector[this.collection.size()]);
    }

    private void add(com.sk89q.worldedit.Vector vector) {
        this.collection.add(new Vector(vector.getX(), vector.getY(), vector.getZ()));
    }

    private void addAll(Set<com.sk89q.worldedit.Vector> vectors) {
        for (com.sk89q.worldedit.Vector vector : vectors) {
            this.collection.add(new Vector(vector.getX(), vector.getY(), vector.getZ()));
        }
    }
}

