/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.CuboidRegion;
import me.limeglass.fawesk.lang.FaweskPropertyExpression;
import me.limeglass.fawesk.utils.annotations.Changers;
import me.limeglass.fawesk.utils.annotations.Properties;
import me.limeglass.fawesk.utils.annotations.PropertiesAddition;
import me.limeglass.fawesk.utils.annotations.Settable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Fawesk - Cuboid region positions")
@Description(value={"Returns either the first or second position vector(s) of the cuboid region(s)."})
@Properties(value={"cuboidregions", "(point|pos[ition])][( |-)](1\u00a61|2\u00a62)", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="cuboid[[ ]region[s]]")
@Changers(value={Changer.ChangeMode.SET})
@Settable(value={Location.class, org.bukkit.util.Vector.class})
public class ExprCuboidRegionPositions
extends FaweskPropertyExpression<CuboidRegion, org.bukkit.util.Vector> {
    protected org.bukkit.util.Vector[] get(Event event, CuboidRegion[] cuboids) {
        CuboidRegion[] cuboidRegionArray = cuboids;
        int n = cuboids.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidRegion cuboid = cuboidRegionArray[n2];
            if (this.patternMark == 1) {
                this.add(cuboid.getPos1());
            } else {
                this.add(cuboid.getPos2());
            }
            ++n2;
        }
        return this.collection.toArray(new org.bukkit.util.Vector[this.collection.size()]);
    }

    private void add(Vector vector) {
        this.collection.add(new org.bukkit.util.Vector(vector.getX(), vector.getY(), vector.getZ()));
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        Object object = delta[0];
        Vector vector = null;
        if (object instanceof org.bukkit.util.Vector) {
            vector = (Vector)object;
        } else if (object instanceof Location) {
            Location location = (Location)object;
            vector = new Vector(location.getX(), location.getY(), location.getZ());
        }
        CuboidRegion[] cuboidRegionArray = this.expressions.getAll(event, CuboidRegion.class);
        int n = cuboidRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidRegion cuboid = cuboidRegionArray[n2];
            if (this.patternMark == 1) {
                cuboid.setPos1(vector);
            } else {
                cuboid.setPos2(vector);
            }
            ++n2;
        }
    }
}

