/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.stream.Collectors;
import me.limeglass.fawesk.lang.FaweskExpression;
import me.limeglass.fawesk.utils.annotations.Patterns;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Fawesk - Cuboid region count of")
@Description(value={"Returns how many of the defined block(s) are in the Cuboid region(s)."})
@Patterns(value={"(size|count|amount) (of|1\u00a6[of] excluding) %itemtypes/baseblocks% (in|within|from) cuboid[[ ]region[s]] %cuboidregions%"})
public class ExprCuboidRegionCountOf
extends FaweskExpression<Number> {
    protected Number[] get(Event event) {
        CuboidRegion[] cuboidRegionArray = this.expressions.getAll(event, CuboidRegion.class);
        int n = cuboidRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidRegion cuboid = cuboidRegionArray[n2];
            HashSet<BaseBlock> blocks = new HashSet<BaseBlock>();
            Object[] objectArray = this.expressions.get(0).getArray(event);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = objectArray[n4];
                if (object instanceof ItemType) {
                    ItemStack item = ((ItemType)object).getRandom();
                    blocks.add(new BaseBlock(item.getTypeId(), (int)item.getData().getData()));
                } else if (object instanceof BaseBlock) {
                    blocks.add((BaseBlock)object);
                }
                ++n4;
            }
            EditSession session = FaweAPI.getEditSessionBuilder((World)cuboid.getWorld()).autoQueue(Boolean.valueOf(true)).build();
            if (this.patternMark == 1) {
                this.collection.add(session.countBlocks((Region)cuboid, session.getBlockDistributionWithData((Region)cuboid).parallelStream().filter(block -> !blocks.contains(block.getID())).map(block -> (BaseBlock)block.getID()).collect(Collectors.toSet())));
            } else {
                this.collection.add(session.countBlocks((Region)cuboid, blocks));
            }
            ++n2;
        }
        return this.collection.toArray(new Number[this.collection.size()]);
    }
}

