/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.fawesk.lang.FaweskPropertyExpression;
import me.limeglass.fawesk.utils.annotations.Properties;
import me.limeglass.fawesk.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Fawesk - Cuboid region count")
@Description(value={"Returns the size/amount of items in the Cuboid region(s)."})
@Properties(value={"cuboidregions", "(size|count|amount)", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="cuboid[[ ]region[s]]")
public class ExprCuboidRegionCount
extends FaweskPropertyExpression<CuboidRegion, Number> {
    protected Number[] get(Event event, CuboidRegion[] cuboids) {
        CuboidRegion[] cuboidRegionArray = cuboids;
        int n = cuboids.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidRegion cuboid = cuboidRegionArray[n2];
            EditSession session = FaweAPI.getEditSessionBuilder((World)cuboid.getWorld()).autoQueue(Boolean.valueOf(true)).build();
            Set blocks = session.getBlockDistributionWithData((Region)cuboid).parallelStream().map(block -> (BaseBlock)block.getID()).collect(Collectors.toSet());
            this.collection.add(session.countBlocks((Region)cuboid, blocks));
            session.flushQueue();
            ++n2;
        }
        return this.collection.toArray(new Number[this.collection.size()]);
    }
}

