/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.fawesk.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.util.Direction;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import me.limeglass.fawesk.Fawesk;
import me.limeglass.fawesk.lang.FaweskEffect;
import me.limeglass.fawesk.objects.FaweskCommandSender;
import me.limeglass.fawesk.utils.annotations.Patterns;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Fawesk - set blocks")
@Description(value={"Sets all the blocks within two points to a block/itemtype."})
@Patterns(value={"set [(all [[of] the]|the)] [fawe[sk]] ((item|block)[ ]types|[base[ ]]blocks) (within|between|from) %block% (and|to) %block% to %string/itemtypes%", "set [(all [[of] the]|the)] [fawe[sk]] ((item|block)[ ]types|[base[ ]]blocks) from %location% [(on|towards)] %direction% to %string/itemtypes%", "set [(all [[of] the]|the)] [fawe[sk]] ((item|block)[ ]types|[base[ ]]blocks) (within|from) %worldeditregion% to %string/itemtypes%"})
public class EffBlocks
extends FaweskEffect {
    protected void execute(Event event) {
        if (this.areNull(event).booleanValue()) {
            return;
        }
        Object from = this.expressions.get(0).getSingle(event);
        Region region = null;
        World world = null;
        Object[] delta = null;
        if (!(from instanceof Region)) {
            Object to = this.expressions.get(1).getSingle(event);
            Location fromLoc = from instanceof Block ? ((Block)from).getLocation() : (Location)from;
            Vector fromVector = new Vector(fromLoc.getX(), fromLoc.getY(), fromLoc.getZ());
            world = BukkitUtil.getLocalWorld((org.bukkit.World)fromLoc.getWorld());
            Location toLoc = to instanceof Block ? ((Block)to).getLocation() : ((Direction)to).getDirection(fromLoc).toLocation(fromLoc.getWorld());
            Vector toVector = new Vector(toLoc.getX(), toLoc.getY(), toLoc.getZ());
            region = new CuboidRegion(world, fromVector, toVector);
            delta = this.expressions.get(2).getAll(event);
        } else if (from instanceof Region) {
            region = (Region)from;
            world = region.getWorld();
            delta = this.expressions.get(1).getAll(event);
        }
        if (world == null) {
            return;
        }
        EditSession session = FaweAPI.getEditSessionBuilder(world).autoQueue(Boolean.valueOf(true)).build();
        session.setBlocks(region, new BaseBlock(0));
        session.flushQueue();
        if (delta != null) {
            if (delta[0] instanceof String) {
                String input = (String)delta[0];
                LocalSession local = new LocalSession();
                local.remember(session);
                ParserContext context = new ParserContext();
                context.setActor((Actor)new FaweskCommandSender(Fawesk.getInstance(), (CommandSender)Bukkit.getConsoleSender()));
                context.setSession(local);
                context.setWorld(world);
                com.sk89q.worldedit.function.pattern.Pattern pattern = null;
                try {
                    pattern = (com.sk89q.worldedit.function.pattern.Pattern)WorldEdit.getInstance().getPatternFactory().parseFromInput(input, context);
                }
                catch (InputParseException e) {
                    Skript.error((String)("The input `" + input + "` was not a valid input for WorldEdit/FAWE, see //patterns"));
                }
                if (pattern == null) {
                    session.undo(session);
                    return;
                }
                session.setBlocks(region, (Pattern)pattern);
            } else if (delta[0] instanceof ItemType) {
                ItemStack item = ((ItemType)delta[0]).getItem().getRandom();
                session.setBlocks(region, new BaseBlock(item.getTypeId(), (int)item.getData().getData()));
            }
        }
        session.flushQueue();
    }
}

