/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.utils;

import net.andrew.utils.ColorMapUtil;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class RectanglePixelMapUtil
extends MapRenderer {
    private boolean rendered;
    private Integer x;
    private Integer y;
    private Integer x2;
    private Integer y2;
    private String color;
    private Integer xsmall;
    private Integer xbig;
    private Integer ysmall;
    private Integer ybig;

    public RectanglePixelMapUtil(String color, Integer x1, Integer y1, Integer x2, Integer y2) {
        this.color = color;
        this.x = x1;
        this.y = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void render(MapView mv, MapCanvas mc, Player p) {
        if (this.rendered || this.color == null) {
            return;
        }
        if (this.x < this.x2) {
            this.xsmall = this.x;
            this.xbig = this.x2;
        } else {
            this.xsmall = this.x2;
            this.xbig = this.x;
        }
        if (this.y < this.y2) {
            this.ysmall = this.y;
            this.ybig = this.y2;
        } else {
            this.ysmall = this.y2;
            this.ybig = this.y;
        }
        int i = this.xsmall;
        while (i < this.xbig) {
            int i2 = this.ysmall;
            while (i2 < this.ybig) {
                mc.setPixel(i, i2, ColorMapUtil.minecraftColorFromString(this.color));
                ++i2;
            }
            ++i;
        }
        this.rendered = true;
    }

    public void setColor(String color) {
        this.color = color;
        this.setRendered(false);
    }

    public String getImage() {
        return this.color;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public boolean hasRendered() {
        return this.rendered;
    }
}

