/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.utils;

import java.util.ArrayList;
import java.util.List;
import net.andrew.utils.ColorMapUtil;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class BorderRectanglePixelMapUtil
extends MapRenderer {
    private boolean rendered;
    private Integer x;
    private Integer y;
    private Integer x2;
    private Integer y2;
    private String color;

    public BorderRectanglePixelMapUtil(String color, Integer x1, Integer y1, Integer x2, Integer y2) {
        this.color = color;
        this.x = x1;
        this.y = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void render(MapView mv, MapCanvas mc, Player p) {
        if (this.rendered || this.color == null) {
            return;
        }
        List<Integer> line1x = this.linex(this.x, this.y, this.x2, this.y);
        List<Integer> line1y = this.liney(this.x, this.y, this.x2, this.y);
        int i = 0;
        while (i < line1x.size()) {
            mc.setPixel(line1x.indexOf(i), line1y.indexOf(i), ColorMapUtil.minecraftColorFromString(this.color));
            ++i;
        }
        List<Integer> line2x = this.linex(this.x, this.y, this.x, this.y2);
        List<Integer> line2y = this.liney(this.x, this.y, this.x, this.y2);
        int i2 = 0;
        while (i2 < line2x.size()) {
            mc.setPixel(line2x.indexOf(i2), line2y.indexOf(i2), ColorMapUtil.minecraftColorFromString(this.color));
            ++i2;
        }
        List<Integer> line3x = this.linex(this.x, this.y2, this.x2, this.y2);
        List<Integer> line3y = this.liney(this.x, this.y2, this.x2, this.y2);
        int i3 = 0;
        while (i3 < line3x.size()) {
            mc.setPixel(line3x.indexOf(i3), line3y.indexOf(i3), ColorMapUtil.minecraftColorFromString(this.color));
            ++i3;
        }
        List<Integer> line4x = this.linex(this.x2, this.y, this.x2, this.y2);
        List<Integer> line4y = this.liney(this.x2, this.y, this.x2, this.y2);
        int i4 = 0;
        while (i4 < line4x.size()) {
            mc.setPixel(line4x.indexOf(i4), line4y.indexOf(i4), ColorMapUtil.minecraftColorFromString(this.color));
            ++i4;
        }
        this.rendered = true;
    }

    public List<Integer> linex(Integer x, Integer y, Integer x22, Integer y22) {
        ArrayList<Integer> xpoints = new ArrayList<Integer>();
        int w = x22 - x;
        int h = y22 - y;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        int i = 0;
        while (i <= longest) {
            xpoints.add(x);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x = x + dx1;
                y = y + dy1;
            } else {
                x = x + dx2;
                y = y + dy2;
            }
            ++i;
        }
        return xpoints;
    }

    public List<Integer> liney(Integer x, Integer y, Integer x22, Integer y22) {
        ArrayList<Integer> ypoints = new ArrayList<Integer>();
        int w = x22 - x;
        int h = y22 - y;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        int i = 0;
        while (i <= longest) {
            ypoints.add(x);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x = x + dx1;
                y = y + dy1;
            } else {
                x = x + dx2;
                y = y + dy2;
            }
            ++i;
        }
        return ypoints;
    }

    public void setColor(String color) {
        this.color = color;
        this.setRendered(false);
    }

    public String getImage() {
        return this.color;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public boolean hasRendered() {
        return this.rendered;
    }
}

