/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;

public class ExprUUIDBits
extends SimplePropertyExpression<String, Number> {
    private int mark;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(expressions, matchedPattern, isDelayed, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    @Nullable
    public Number convert(String s) {
        if (s.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
            UUID uuid = UUID.fromString(s);
            return this.mark == 0 ? uuid.getMostSignificantBits() : uuid.getLeastSignificantBits();
        }
        return null;
    }

    protected String getPropertyName() {
        return "most/least bits of UUID";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprUUIDBits.register(ExprUUIDBits.class, Number.class, (String)"(0\u00a6most|1\u00a6least)[ significant][ bits]", (String)"string");
    }
}

