/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;

public class ExprSpawnerDelay
extends SimplePropertyExpression<Block, Number> {
    private int mark;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    @Nullable
    public Number convert(Block block) {
        if (block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        BlockState state = block.getState();
        CreatureSpawner spawner = (CreatureSpawner)state;
        return this.mark == 0 ? spawner.getDelay() : (this.mark == 1 ? spawner.getMinSpawnDelay() : spawner.getMaxSpawnDelay());
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block block;
        if (delta != null && (block = (Block)this.getExpr().getSingle(event)).getType() == Material.MOB_SPAWNER) {
            BlockState state = block.getState();
            CreatureSpawner spawner = (CreatureSpawner)state;
            Integer value = ((Number)delta[0]).intValue();
            Integer cur = spawner.getDelay();
            Integer min = spawner.getMinSpawnDelay();
            Integer max = spawner.getMaxSpawnDelay();
            switch (mode) {
                case ADD: {
                    if (this.mark == 0) {
                        spawner.setDelay(cur + value);
                    } else if (this.mark == 1) {
                        if (min + value > max) {
                            spawner.setMaxSpawnDelay(min + value);
                        }
                        spawner.setMinSpawnDelay(min + value);
                    } else {
                        if (max + value < min) {
                            spawner.setMinSpawnDelay(max + value);
                        }
                        spawner.setMaxSpawnDelay(max + value);
                    }
                    spawner.update();
                    break;
                }
                case REMOVE: {
                    if (this.mark == 0) {
                        spawner.setDelay(cur - value);
                    } else if (this.mark == 1) {
                        spawner.setMinSpawnDelay(min - value);
                    } else {
                        if (max - value < min) {
                            spawner.setMinSpawnDelay(max - value);
                        }
                        spawner.setMaxSpawnDelay(max - value);
                    }
                    spawner.update();
                    break;
                }
                case SET: {
                    if (this.mark == 0) {
                        spawner.setDelay(value.intValue());
                    } else if (this.mark == 1) {
                        if (value > max) {
                            spawner.setMaxSpawnDelay(value.intValue());
                        }
                        spawner.setMinSpawnDelay(value.intValue());
                    } else {
                        if (value < min) {
                            spawner.setMinSpawnDelay(value.intValue());
                        }
                        spawner.setMaxSpawnDelay(value.intValue());
                    }
                    spawner.update();
                    break;
                }
                case RESET: {
                    if (this.mark == 0) {
                        spawner.setDelay(max.intValue());
                    } else if (this.mark == 1) {
                        spawner.setMinSpawnDelay(200);
                    } else {
                        spawner.setMaxSpawnDelay(800);
                    }
                    spawner.update();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "spawner delay";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprSpawnerDelay.register(ExprSpawnerDelay.class, Number.class, (String)"(0\u00a6current|1\u00a6min[imum]|2\u00a6max[imum]) [spawn( |-)](delay|cooldown)", (String)"block");
    }
}

