/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;

public class ExprSpawnCount
extends SimplePropertyExpression<Block, Number> {
    @Nullable
    public Number convert(Block block) {
        if (block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        BlockState state = block.getState();
        CreatureSpawner spawner = (CreatureSpawner)state;
        return spawner.getSpawnCount();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block block;
        if (delta != null && (block = (Block)this.getExpr().getSingle(event)).getType() == Material.MOB_SPAWNER) {
            BlockState state = block.getState();
            CreatureSpawner spawner = (CreatureSpawner)state;
            Integer value = ((Number)delta[0]).intValue();
            switch (mode) {
                case ADD: {
                    spawner.setSpawnCount(spawner.getSpawnCount() + value);
                    break;
                }
                case REMOVE: {
                    spawner.setSpawnCount(spawner.getSpawnCount() - value);
                    break;
                }
                case SET: {
                    spawner.setSpawnCount(value.intValue());
                    break;
                }
                case RESET: {
                    spawner.setSpawnCount(4);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "entity spawn count";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprSpawnCount.register(ExprSpawnCount.class, Number.class, (String)"[entity( |-)]spawn count", (String)"block");
    }
}

