/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;

public class ExprSlimeSize
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity.getType() == EntityType.SLIME) {
            return ((Slime)entity).getSize();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Entity entity;
        if (delta != null && this.getExpr().getSingle(event) != null && (entity = (Entity)this.getExpr().getSingle(event)).getType() == EntityType.SLIME) {
            Slime slime = (Slime)entity;
            Integer v = ((Number)delta[0]).intValue();
            Integer cur = slime.getSize();
            switch (mode) {
                case ADD: {
                    slime.setSize(Math.max(0, cur + v));
                    break;
                }
                case REMOVE: {
                    slime.setSize(Math.max(0, cur - v));
                    break;
                }
                case SET: {
                    slime.setSize(Math.max(0, v));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "size";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprSlimeSize.register(ExprSlimeSize.class, Number.class, (String)"[slime( |-)]size", (String)"entity");
    }
}

