/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;

public class ExprRequiredPlayerRange
extends SimplePropertyExpression<Block, Number> {
    @Nullable
    public Number convert(Block block) {
        if (block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        BlockState state = block.getState();
        CreatureSpawner spawner = (CreatureSpawner)state;
        return spawner.getRequiredPlayerRange();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block block;
        if (delta != null && (block = (Block)this.getExpr().getSingle(event)).getType() == Material.MOB_SPAWNER) {
            BlockState state = block.getState();
            CreatureSpawner spawner = (CreatureSpawner)state;
            Integer value = ((Number)delta[0]).intValue();
            switch (mode) {
                case ADD: {
                    spawner.setRequiredPlayerRange(spawner.getRequiredPlayerRange() + value);
                    break;
                }
                case REMOVE: {
                    spawner.setRequiredPlayerRange(spawner.getRequiredPlayerRange() - value);
                    break;
                }
                case SET: {
                    spawner.setRequiredPlayerRange(value.intValue());
                    break;
                }
                case RESET: {
                    spawner.setRequiredPlayerRange(16);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "required player range";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprRequiredPlayerRange.register(ExprRequiredPlayerRange.class, Number.class, (String)"required [player( |-)]range", (String)"block");
    }
}

