/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;

public class ExprMaxNearbyEntities
extends SimplePropertyExpression<Block, Number> {
    @Nullable
    public Number convert(Block block) {
        if (block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        BlockState state = block.getState();
        CreatureSpawner spawner = (CreatureSpawner)state;
        return spawner.getMaxNearbyEntities();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block block;
        if (delta != null && (block = (Block)this.getExpr().getSingle(event)).getType() == Material.MOB_SPAWNER) {
            BlockState state = block.getState();
            CreatureSpawner spawner = (CreatureSpawner)state;
            Integer value = ((Number)delta[0]).intValue();
            switch (mode) {
                case ADD: {
                    spawner.setMaxNearbyEntities(spawner.getMaxNearbyEntities() + value);
                    break;
                }
                case REMOVE: {
                    spawner.setMaxNearbyEntities(spawner.getMaxNearbyEntities() - value);
                    break;
                }
                case SET: {
                    spawner.setMaxNearbyEntities(value.intValue());
                    break;
                }
                case RESET: {
                    spawner.setMaxNearbyEntities(6);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "max nearby entities";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprMaxNearbyEntities.register(ExprMaxNearbyEntities.class, Number.class, (String)"max[imum] (entities nearby|nearby entities)", (String)"block");
    }
}

