/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;

public class ExprMaxFuseTicks
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity.getType() == EntityType.CREEPER) {
            return ((Creeper)entity).getMaxFuseTicks();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Entity entity;
        if (delta != null && this.getExpr().getSingle(event) != null && (entity = (Entity)this.getExpr().getSingle(event)).getType() == EntityType.CREEPER) {
            Creeper creeper = (Creeper)entity;
            Integer v = ((Number)delta[0]).intValue();
            Integer cur = creeper.getMaxFuseTicks();
            switch (mode) {
                case ADD: {
                    creeper.setMaxFuseTicks(Math.max(0, cur + v));
                    break;
                }
                case REMOVE: {
                    creeper.setMaxFuseTicks(Math.max(0, cur - v));
                    break;
                }
                case SET: {
                    creeper.setMaxFuseTicks(Math.max(0, v));
                    break;
                }
                case RESET: {
                    creeper.setMaxFuseTicks(30);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "maximum fuse ticks";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprMaxFuseTicks.register(ExprMaxFuseTicks.class, Number.class, (String)"max[imum] fuse ticks", (String)"entity");
    }
}

