/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;

public class ExprItemFrameRotation
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity.getType() == EntityType.ITEM_FRAME) {
            Rotation rot = ((ItemFrame)entity).getRotation();
            return rot.ordinal();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Entity entity;
        if (delta != null && this.getExpr().getSingle(event) != null && (entity = (Entity)this.getExpr().getSingle(event)).getType() == EntityType.ITEM_FRAME) {
            ItemFrame frame = (ItemFrame)entity;
            Integer v = ((Number)delta[0]).intValue();
            Integer cur = frame.getRotation().ordinal();
            switch (mode) {
                case ADD: {
                    frame.setRotation(Rotation.values()[(cur + v) % 8]);
                    break;
                }
                case REMOVE: {
                    frame.setRotation(Rotation.values()[(cur + (8 - v % 8)) % 8]);
                    break;
                }
                case SET: {
                    frame.setRotation(Rotation.values()[Math.max(0, Math.min(7, v))]);
                    break;
                }
                case RESET: {
                    frame.setRotation(Rotation.NONE);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "display item rotation";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprItemFrameRotation.register(ExprItemFrameRotation.class, Number.class, (String)"[display( |-)]item rotation", (String)"entity");
    }
}

