/*
 * Decompiled with CFR 0.152.
 */
package de.jaylawl.expressionsplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.event.Event;

public class ExprArmorStandVisibility
extends SimplePropertyExpression<ArmorStand, Boolean> {
    private int mark;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    @Nullable
    public Boolean convert(ArmorStand entity) {
        return this.mark == 0 ? entity.isVisible() : (this.mark == 1 ? entity.hasArms() : entity.hasBasePlate());
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            ArmorStand entity = (ArmorStand)this.getExpr().getSingle(event);
            Boolean value = (Boolean)delta[0];
            switch (mode) {
                case SET: {
                    if (this.mark == 0) {
                        entity.setVisible(value.booleanValue());
                        break;
                    }
                    if (this.mark == 1) {
                        entity.setArms(value.booleanValue());
                        break;
                    }
                    entity.setBasePlate(value.booleanValue());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "full/arm/baseplate visibility";
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    static {
        ExprArmorStandVisibility.register(ExprArmorStandVisibility.class, Boolean.class, (String)"(0\u00a6visibility|1\u00a6arm( |-)visibility|2\u00a6[base( |-)]plate( |-)visibility)", (String)"entity");
    }
}

