/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.effects.consoles;

import ca.jarcode.consoles.api.CanvasComponent;
import ca.jarcode.consoles.api.Console;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.andrew.Main;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.map.MapPalette;
import org.bukkit.plugin.Plugin;

public class EffGIFConsole
extends Effect {
    private Integer label;
    private Expression<String> url;
    private Expression<Console> console;
    private Expression<Number> x;
    private Expression<Number> y;

    public boolean init(Expression<?>[] expr, int label, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.label = label;
        this.url = expr[0];
        this.console = expr[1];
        if (label == 1) {
            this.x = expr[2];
            this.y = expr[3];
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean bool) {
        return "render gif [image] from (URL|FILE) %string% on [to] %console% [starting at %number%[,] %number%]";
    }

    protected void execute(Event e) {
        ImageInputStream is;
        InputStream is2;
        Integer y1;
        Integer x1;
        Console console1 = (Console)this.console.getSingle(e);
        if (this.label == 1) {
            Number x2 = (Number)this.x.getSingle(e);
            Number y2 = (Number)this.y.getSingle(e);
            x2 = Math.round(x2.doubleValue());
            y2 = Math.round(y2.doubleValue());
            x1 = x2.intValue();
            y1 = y2.intValue();
        } else {
            x1 = 1;
            y1 = 1;
        }
        if (this.label == 0) {
            try {
                is2 = new URL((String)this.url.getSingle(e)).openStream();
                is = ImageIO.createImageInputStream(is2);
            }
            catch (Exception e1) {
                Main.inst().getLogger().warning("Could not retreive image from URL " + (String)this.url.getSingle(e) + " due to " + e1.getMessage() + "!");
                return;
            }
        }
        try {
            is2 = new FileInputStream((String)this.url.getSingle(e));
            is = ImageIO.createImageInputStream(is2);
        }
        catch (Exception e1) {
            Main.inst().getLogger().warning("Could not retreive image from FILE " + (String)this.url.getSingle(e) + " due to " + e1.getMessage() + "!");
            return;
        }
        try {
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(is);
            int count = reader.getNumImages(true);
            CanvasComponent prevcomp = null;
            int index = 0;
            while (index < count) {
                BufferedImage frame = reader.read(index);
                System.out.println(Integer.toString(count));
                CanvasComponent comp = console1.newComponent(frame.getWidth(), frame.getHeight()).painter((g, context) -> {
                    int x = 0;
                    while (x < frame.getWidth()) {
                        int y = 0;
                        while (y < frame.getHeight()) {
                            int clr = frame.getRGB(x, y);
                            int red = (clr & 0xFF0000) >> 16;
                            int green = (clr & 0xFF00) >> 8;
                            int blue = clr & 0xFF;
                            if (clr >> 24 != 0) {
                                g.draw(x, y, MapPalette.matchColor((int)red, (int)green, (int)blue));
                            }
                            ++y;
                        }
                        ++x;
                    }
                }).create();
                if (prevcomp != null) {
                    console1.getCanvas().removeComponent(prevcomp);
                }
                prevcomp = comp;
                console1.getCanvas().putComponent(x1.intValue(), y1.intValue(), comp);
                console1.getCanvas().repaint();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.inst(), new Runnable(){

                    @Override
                    public void run() {
                    }
                }, 10L);
                ++index;
            }
        }
        catch (IOException ex) {
            Main.inst().getLogger().warning("Could not retreive frames from gif " + (String)this.url.getSingle(e) + " due to " + ex.getMessage() + "!");
        }
    }
}

