/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.utils.maps;

import net.andrew.utils.maps.ColorMapUtil;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class LinePixelMapUtil
extends MapRenderer {
    private boolean rendered;
    private Integer x;
    private Integer y;
    private Integer x2;
    private Integer y2;
    private String color;

    public LinePixelMapUtil(String color, Integer x1, Integer y1, Integer x2, Integer y2) {
        this.color = color;
        this.x = x1;
        this.y = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void render(MapView mv, final MapCanvas mc, Player p) {
        if (this.rendered || this.color == null) {
            return;
        }
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int w = LinePixelMapUtil.this.x2 - LinePixelMapUtil.this.x;
                int h = LinePixelMapUtil.this.y2 - LinePixelMapUtil.this.y;
                int dx1 = 0;
                int dy1 = 0;
                int dx2 = 0;
                int dy2 = 0;
                if (w < 0) {
                    dx1 = -1;
                } else if (w > 0) {
                    dx1 = 1;
                }
                if (h < 0) {
                    dy1 = -1;
                } else if (h > 0) {
                    dy1 = 1;
                }
                if (w < 0) {
                    dx2 = -1;
                } else if (w > 0) {
                    dx2 = 1;
                }
                int longest = Math.abs(w);
                int shortest = Math.abs(h);
                if (longest <= shortest) {
                    longest = Math.abs(h);
                    shortest = Math.abs(w);
                    if (h < 0) {
                        dy2 = -1;
                    } else if (h > 0) {
                        dy2 = 1;
                    }
                    dx2 = 0;
                }
                int numerator = longest >> 1;
                int i = 0;
                while (i <= longest) {
                    mc.setPixel(LinePixelMapUtil.this.x.intValue(), LinePixelMapUtil.this.y.intValue(), ColorMapUtil.minecraftColorFromString(LinePixelMapUtil.this.color));
                    if ((numerator += shortest) >= longest) {
                        numerator -= longest;
                        LinePixelMapUtil linePixelMapUtil = LinePixelMapUtil.this;
                        linePixelMapUtil.x = linePixelMapUtil.x + dx1;
                        LinePixelMapUtil linePixelMapUtil2 = LinePixelMapUtil.this;
                        linePixelMapUtil2.y = linePixelMapUtil2.y + dy1;
                    } else {
                        LinePixelMapUtil linePixelMapUtil = LinePixelMapUtil.this;
                        linePixelMapUtil.x = linePixelMapUtil.x + dx2;
                        LinePixelMapUtil linePixelMapUtil3 = LinePixelMapUtil.this;
                        linePixelMapUtil3.y = linePixelMapUtil3.y + dy2;
                    }
                    ++i;
                }
            }
        });
        t1.start();
        this.rendered = true;
    }

    public void setColor(String color) {
        this.color = color;
        this.setRendered(false);
    }

    public String getImage() {
        return this.color;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public boolean hasRendered() {
        return this.rendered;
    }
}

