/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.utils.imgmessage;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.andrew.utils.imgmessage.ImageMessage;

public class AnimatedMessage {
    private ImageMessage[] images;
    private int index = 0;

    public AnimatedMessage(ImageMessage ... images) {
        this.images = images;
    }

    public AnimatedMessage(File gifFile, int height, char imgChar) throws IOException {
        List<BufferedImage> frames = this.getFrames(gifFile);
        this.images = new ImageMessage[frames.size()];
        int i = 0;
        while (i < frames.size()) {
            this.images[i] = new ImageMessage(frames.get(i), height, imgChar);
            ++i;
        }
    }

    public List<BufferedImage> getFrames(File input) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
            ImageInputStream in = ImageIO.createImageInputStream(input);
            reader.setInput(in);
            int i = 0;
            int count = reader.getNumImages(true);
            while (i < count) {
                BufferedImage image = reader.read(i);
                images.add(image);
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return images;
    }

    public ImageMessage current() {
        return this.images[this.index];
    }

    public ImageMessage next() {
        ++this.index;
        if (this.index >= this.images.length) {
            this.index = 0;
            return this.images[this.index];
        }
        return this.images[this.index];
    }

    public ImageMessage previous() {
        --this.index;
        if (this.index <= 0) {
            this.index = this.images.length - 1;
            return this.images[this.index];
        }
        return this.images[this.index];
    }

    public ImageMessage getIndex(int index) {
        return this.images[index];
    }
}

