/*
 * Decompiled with CFR 0.152.
 */
package net.andrew.effects.consoles;

import ca.jarcode.consoles.api.CanvasComponent;
import ca.jarcode.consoles.api.Console;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.andrew.Main;
import org.bukkit.event.Event;
import org.bukkit.map.MapPalette;

public class EffImageConsole
extends Effect {
    private Expression<String> URL;
    private Expression<Console> console;
    private URL url1;
    private BufferedImage image;
    private Integer pr;
    private Integer label;
    private File file1;
    private Expression<Number> x;
    private Expression<Number> y;

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.URL = expr[0];
        this.console = expr[1];
        this.pr = arg3.mark;
        this.label = arg1;
        if (arg1 == 1) {
            this.x = expr[2];
            this.y = expr[3];
        }
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "render image from (URL|FILE) %string% on [to] %console%";
    }

    protected void execute(Event e) {
        try {
            this.url1 = new URL((String)this.URL.getSingle(e));
            this.file1 = new File((String)this.URL.getSingle(e));
        }
        catch (MalformedURLException e1) {
            Main.inst().getLogger().warning("Invalid URL " + (String)this.URL.getSingle(e) + " for render image on console!");
            return;
        }
        try {
            if (this.pr == 0) {
                this.image = ImageIO.read(this.url1);
            } else if (this.pr == 1) {
                this.image = ImageIO.read(this.file1);
            }
        }
        catch (IOException e2) {
            String s = this.pr == 0 ? "URL " : "FILE ";
            Main.inst().getLogger().warning("Could not retreive image from" + s + (String)this.URL.getSingle(e) + " Due to:" + e2.getMessage());
            return;
        }
        Console console1 = (Console)this.console.getSingle(e);
        CanvasComponent comp = console1.newComponent(this.image.getWidth(), this.image.getHeight()).painter((g, context) -> {
            int x = 0;
            while (x < this.image.getWidth()) {
                int y = 0;
                while (y < this.image.getHeight()) {
                    int clr = this.image.getRGB(x, y);
                    int red = (clr & 0xFF0000) >> 16;
                    int green = (clr & 0xFF00) >> 8;
                    int blue = clr & 0xFF;
                    if (clr >> 24 != 0) {
                        g.draw(x, y, MapPalette.matchColor((int)red, (int)green, (int)blue));
                    }
                    ++y;
                }
                ++x;
            }
        }).create();
        Integer x1 = 1;
        Integer y1 = 1;
        if (this.label == 1) {
            Number x2 = (Number)this.x.getSingle(e);
            Number y2 = (Number)this.y.getSingle(e);
            x1 = x2.intValue();
            y1 = y2.intValue();
        }
        console1.getCanvas().putComponent(x1.intValue(), y1.intValue(), comp);
    }
}

