/*
 * Decompiled with CFR 0.152.
 */
package com.github.cc007.eventsk;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.cc007.eventsk.EventSK;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.event.Event;

public class ExprBukkitEventVariable<T>
extends SimpleExpression<T> {
    private Class<? extends Event> eventClass;
    private Method eventMethod;

    protected T[] get(Event e) {
        try {
            return new Object[]{this.eventClass.isInstance(e) ? this.eventMethod.invoke((Object)e, new Object[0]) : null};
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new SkriptAPIException("Unable to get value", (Throwable)ex);
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends T> getReturnType() {
        return this.eventMethod.getReturnType();
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        String eventName = parseResult.expr.split("-")[0];
        String methodName = parseResult.expr.split("-")[1];
        Class<Event> evtClass = null;
        try {
            for (String event : EventSK.getPlugin().getConfig().getStringList("events")) {
                if (!event.contains(eventName)) continue;
                evtClass = Class.forName(event).asSubclass(Event.class);
                break;
            }
            if (evtClass == null) {
                Skript.error((String)("Cannot use '" + parseResult.expr + "', its event isn't added to the config"));
                return false;
            }
            if (!ScriptLoader.isCurrentEvent(evtClass)) {
                Skript.error((String)("Cannot use '" + parseResult.expr + "' outside of " + eventName + " events"));
                return false;
            }
            this.eventClass = evtClass;
            this.eventMethod = evtClass.getMethod(methodName, new Class[0]);
            return true;
        }
        catch (ClassNotFoundException ex) {
            Skript.error((String)("Cannot use '" + parseResult.expr + "', its corresponding bukkit event doesn't exist or can't be reached (check the spelling of the event!)"));
        }
        catch (NoSuchMethodException ex) {
            Skript.error((String)("Cannot use '" + parseResult.expr + "', its event doesn't have a method named " + methodName));
        }
        catch (SecurityException ex) {
            Logger.getLogger(ExprBukkitEventVariable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public String toString(Event arg0, boolean arg1) {
        return this.eventClass.getName() + "-" + this.eventMethod.getName();
    }
}

