/*
 * Decompiled with CFR 0.152.
 */
package com.github.cc007.eventsk;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import com.github.cc007.eventsk.BukkitEvent;
import com.github.cc007.eventsk.ExprBukkitEventVariable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EventSK
extends JavaPlugin {
    private FileConfiguration config = null;
    private File configFile = null;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        Skript.registerAddon((JavaPlugin)this);
        Iterator it = this.getConfig().getList("events").iterator();
        while (it.hasNext()) {
            try {
                String fullEventName = (String)it.next();
                Class<Event> eventClass = Class.forName(fullEventName).asSubclass(Event.class);
                Skript.registerEvent((String)"Bukkit event", BukkitEvent.class, eventClass, (String[])new String[]{"bukkit event %strings%"});
                String[] splitName = fullEventName.split("\\.");
                String eventName = splitName[splitName.length - 1];
                for (Method method : eventClass.getMethods()) {
                    if (method.getName().equals("isAsynchronous") || method.getName().equals("getHandlers") || method.getName().equals("getHandlerList") || method.getName().equals("wait") || method.getName().equals("equals") || method.getName().equals("hashCode") || method.getName().equals("notify") || method.getName().equals("notifyAll")) continue;
                    Skript.registerExpression(ExprBukkitEventVariable.class, method.getReturnType(), (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{eventName + "-" + method.getName()});
                }
            }
            catch (ClassNotFoundException ex) {
                this.getLogger().warning("[EventSK] The event named " + ex.getMessage() + " doesn't exist or can't be reached. Make sure you spelled the event name correctly and that the event is available on the server.");
            }
        }
    }

    public static EventSK getPlugin() {
        Plugin eventSK = Bukkit.getServer().getPluginManager().getPlugin("EventSK");
        if (eventSK != null && eventSK.isEnabled() && eventSK instanceof EventSK) {
            return (EventSK)eventSK;
        }
        Bukkit.getLogger().log(Level.WARNING, "EventSK has not been enabled yet");
        return null;
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.getDataFolder(), "config.yml");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStreamReader defConfigStream = null;
        try {
            defConfigStream = new InputStreamReader(this.getResource("config.yml"), "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void saveConfig() {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, ex);
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.saveResource("config.yml", false);
        }
    }
}

