/*
 * Decompiled with CFR 0.152.
 */
package com.github.cc007.eventsk;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;

public class BukkitEvent
extends SkriptEvent {
    private String fullEventName;

    public boolean check(Event e) {
        return e.getClass().getName().equals(this.fullEventName);
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (args.length != 1) {
            throw new SkriptAPIException("Invalid use of BukkitEvent: 1 argument expected");
        }
        if (!String.class.isInstance(args[0].getSingle())) {
            throw new SkriptAPIException("Invalid use of BukkitEvent: argument expected to be a String");
        }
        Literal<?> eventLiteral = args[0];
        this.fullEventName = (String)eventLiteral.getSingle();
        try {
            Class<Event> eventClass = Class.forName(this.fullEventName).asSubclass(Event.class);
        }
        catch (ClassNotFoundException ex) {
            throw new SkriptAPIException("Invalid use of BukkitEvent: no bukkit event with that name exists");
        }
        return true;
    }

    public String toString(Event arg0, boolean arg1) {
        return "Bukkit event";
    }
}

