/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.papiaddon.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.pikachu.papiaddon.Main;
import com.pikachu.papiaddon.placeholderapi.PlaceholderAPIEvent;
import com.pikachu.papiaddon.placeholderapi.PlaceholderAPIListener;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="On Placeholder Request")
@Description(value={"Called whenever a placeholder is requested"})
@Examples(value={"on placeholder request with prefix \"example\":\n\tif the identifier is \"name\": # example_name\n\t\tset the result to player's name\n\telse if the identifier is \"uuid\": # example_uuid\n\t\tset the result to the player's uuid\n\telse if the identifier is \"money\": # example_money\n\t\tset the result to \"$%{money::%player's uuid%}%\""})
public class EvtPlaceholderRequest
extends SkriptEvent {
    private String prefix;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.prefix = (String)args[0].getSingle();
        if ("".equals(this.prefix)) {
            Skript.error((String)(this.prefix + " is not a valid placeholder"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        new PlaceholderAPIListener(Main.getInstance(), this.prefix).hook();
        return true;
    }

    public boolean check(Event e) {
        return ((PlaceholderAPIEvent)e).getPrefix().equalsIgnoreCase(this.prefix);
    }

    public String toString(Event e, boolean debug) {
        return "placeholder request" + (this.prefix != null ? "with prefix \"" + this.prefix + "\"" : "");
    }

    static {
        Skript.registerEvent((String)"Placeholder Request", EvtPlaceholderRequest.class, PlaceholderAPIEvent.class, (String[])new String[]{"(placeholder[api]|papi) request with [the] prefix %string%"});
        EventValues.registerEventValue(PlaceholderAPIEvent.class, Player.class, (Getter)new Getter<Player, PlaceholderAPIEvent>(){

            public Player get(PlaceholderAPIEvent e) {
                return e.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(PlaceholderAPIEvent.class, String.class, (Getter)new Getter<String, PlaceholderAPIEvent>(){

            public String get(PlaceholderAPIEvent e) {
                return e.getIdentifier();
            }
        }, (int)0);
    }
}

