/*
 * Decompiled with CFR 0.152.
 */
package me.snowleo.dsskriptaddon;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import me.snowleo.dsskriptaddon.classes.ObjectParser;
import me.snowleo.dsskriptaddon.classes.ObjectTypeParser;
import me.snowleo.dsskriptaddon.classes.VehicleParser;
import me.snowleo.dsskriptaddon.condition.DrivingCondition;
import me.snowleo.dsskriptaddon.condition.OwningCondition;
import me.snowleo.dsskriptaddon.condition.SpawningCondition;
import me.snowleo.dsskriptaddon.effect.ObjectGiveEffect;
import me.snowleo.dsskriptaddon.effect.VehicleDespawnEffect;
import me.snowleo.dsskriptaddon.effect.VehicleEjectEffect;
import me.snowleo.dsskriptaddon.effect.VehicleFuelEffect;
import me.snowleo.dsskriptaddon.effect.VehicleSpawnEffect;
import me.snowleo.dsskriptaddon.event.ObjectTypeEvent;
import me.snowleo.dsskriptaddon.expression.ObjectCollectionExpression;
import me.snowleo.dsskriptaddon.expression.ObjectOwnerExpression;
import me.snowleo.dsskriptaddon.expression.VehicleFuelExpression;
import me.snowleo.dsskriptaddon.expression.VehicleInUseExpression;
import me.snowleo.dsskriptaddon.expression.VehicleSpawnedExpression;
import me.snowleo.dynamicstands.DynamicStands;
import me.snowleo.dynamicstands.events.ObjectDespawnEvent;
import me.snowleo.dynamicstands.events.ObjectSpawnEvent;
import me.snowleo.dynamicstands.events.VehicleEjectEvent;
import me.snowleo.dynamicstands.events.VehicleFuelEvent;
import me.snowleo.dynamicstands.events.VehicleMountEvent;
import me.snowleo.dynamicstands.model.objects.DSObject;
import me.snowleo.dynamicstands.model.objects.build.ObjectType;
import me.snowleo.dynamicstands.model.objects.moveable.DSMoveableObject;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptAddon
extends JavaPlugin {
    private static final String OBJECT_TYPE = "objtype";
    private static DynamicStands dynamicStands;

    public void onDisable() {
        this.getLogger().info("Shutting down...");
    }

    public void onEnable() {
        this.loadSkriptExtension();
    }

    private void loadSkriptExtension() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("Skript") != null && pm.getPlugin("DynamicStands") != null) {
            dynamicStands = (DynamicStands)DynamicStands.getInstance();
            this.getLogger().info("DynamicStands has been found and the skript addon has been loaded.");
            Skript.registerAddon((JavaPlugin)this);
            this.registerClasses();
            this.registerEvents();
            this.registerConditions();
            this.registerEffects();
            this.registerExpressions();
        }
    }

    private void registerEvents() {
        Skript.registerEvent((String)"ObjectSpawnEvent", ObjectTypeEvent.class, ObjectSpawnEvent.class, (String[])new String[]{"[on] spawn[ing] object [[of type] %objtype%]"});
        EventValues.registerEventValue(ObjectSpawnEvent.class, Player.class, (Getter)new Getter<Player, ObjectSpawnEvent>(){

            public Player get(ObjectSpawnEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(ObjectSpawnEvent.class, ObjectType.class, (Getter)new Getter<ObjectType, ObjectSpawnEvent>(){

            public ObjectType get(ObjectSpawnEvent event) {
                return event.getObjectType();
            }
        }, (int)0);
        EventValues.registerEventValue(ObjectSpawnEvent.class, Location.class, (Getter)new Getter<Location, ObjectSpawnEvent>(){

            public Location get(ObjectSpawnEvent event) {
                return event.getSpawnLocation();
            }
        }, (int)0);
        Skript.registerEvent((String)"ObjectDespawnEvent", ObjectTypeEvent.class, ObjectDespawnEvent.class, (String[])new String[]{"[on] despawn[ing] object [[of type] %objtype%]"});
        EventValues.registerEventValue(ObjectDespawnEvent.class, Player.class, (Getter)new Getter<Player, ObjectDespawnEvent>(){

            public Player get(ObjectDespawnEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(ObjectDespawnEvent.class, ObjectType.class, (Getter)new Getter<ObjectType, ObjectDespawnEvent>(){

            public ObjectType get(ObjectDespawnEvent event) {
                return event.getObjectType();
            }
        }, (int)0);
        Skript.registerEvent((String)"VehicleMountEvent", ObjectTypeEvent.class, VehicleMountEvent.class, (String[])new String[]{"[on] join[ing] vehicle [[of type] %objtype%]"});
        EventValues.registerEventValue(VehicleMountEvent.class, Player.class, (Getter)new Getter<Player, VehicleMountEvent>(){

            public Player get(VehicleMountEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleMountEvent.class, ObjectType.class, (Getter)new Getter<ObjectType, VehicleMountEvent>(){

            public ObjectType get(VehicleMountEvent event) {
                return event.getObjectType();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleMountEvent.class, DSMoveableObject.class, (Getter)new Getter<DSMoveableObject, VehicleMountEvent>(){

            public DSMoveableObject get(VehicleMountEvent event) {
                return event.getVehicle();
            }
        }, (int)0);
        Skript.registerEvent((String)"VehicleEjectEvent", ObjectTypeEvent.class, VehicleEjectEvent.class, (String[])new String[]{"[on] eject[ing] vehicle [[of type] %objtype%]"});
        EventValues.registerEventValue(VehicleEjectEvent.class, Player.class, (Getter)new Getter<Player, VehicleEjectEvent>(){

            public Player get(VehicleEjectEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleEjectEvent.class, ObjectType.class, (Getter)new Getter<ObjectType, VehicleEjectEvent>(){

            public ObjectType get(VehicleEjectEvent event) {
                return event.getObjectType();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleEjectEvent.class, DSMoveableObject.class, (Getter)new Getter<DSMoveableObject, VehicleEjectEvent>(){

            public DSMoveableObject get(VehicleEjectEvent event) {
                return event.getVehicle();
            }
        }, (int)0);
        Skript.registerEvent((String)"VehicleFuelEvent", ObjectTypeEvent.class, VehicleFuelEvent.class, (String[])new String[]{"[on] fuel[ing] vehicle [[of type] %objtype%]"});
        EventValues.registerEventValue(VehicleFuelEvent.class, Player.class, (Getter)new Getter<Player, VehicleFuelEvent>(){

            public Player get(VehicleFuelEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleFuelEvent.class, ObjectType.class, (Getter)new Getter<ObjectType, VehicleFuelEvent>(){

            public ObjectType get(VehicleFuelEvent event) {
                return event.getObjectType();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleFuelEvent.class, DSMoveableObject.class, (Getter)new Getter<DSMoveableObject, VehicleFuelEvent>(){

            public DSMoveableObject get(VehicleFuelEvent event) {
                return event.getVehicle();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleFuelEvent.class, Double.TYPE, (Getter)new Getter<Double, VehicleFuelEvent>(){

            public Double get(VehicleFuelEvent event) {
                return event.getLitre();
            }
        }, (int)0);
        EventValues.registerEventValue(VehicleFuelEvent.class, Double.TYPE, (Getter)new Getter<Double, VehicleFuelEvent>(){

            public Double get(VehicleFuelEvent event) {
                return event.getPrice();
            }
        }, (int)0);
    }

    private void registerConditions() {
        Skript.registerCondition(DrivingCondition.class, (String[])new String[]{"%player% is driving"});
        Skript.registerCondition(OwningCondition.class, (String[])new String[]{"%player% owns %objtype%"});
        Skript.registerCondition(SpawningCondition.class, (String[])new String[]{"%player% has spawned %objtype%"});
    }

    private void registerEffects() {
        Skript.registerEffect(VehicleEjectEffect.class, (String[])new String[]{"eject[s] %player%"});
        Skript.registerEffect(VehicleSpawnEffect.class, (String[])new String[]{"spawn [the] object %objtype% for %player%"});
        Skript.registerEffect(VehicleDespawnEffect.class, (String[])new String[]{"despawn [the] object %objtype% from %player%"});
        Skript.registerEffect(VehicleFuelEffect.class, (String[])new String[]{"fuel [the] object %vehicle% to %number%", "fuel [the] object %vehicle% by %number%"});
        Skript.registerEffect(ObjectGiveEffect.class, (String[])new String[]{"give object of type %objtype% to %player%"});
    }

    private void registerExpressions() {
        Skript.registerExpression(VehicleInUseExpression.class, DSMoveableObject.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"current vehicle of %player%"});
        Skript.registerExpression(VehicleSpawnedExpression.class, DSMoveableObject.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"vehicle of %player% with type %objtype%"});
        Skript.registerExpression(ObjectCollectionExpression.class, ObjectType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[get] [all] objects of %player%"});
        Skript.registerExpression(ObjectOwnerExpression.class, Player.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"owner of %dsobject%"});
        Skript.registerExpression(VehicleFuelExpression.class, Double.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[get] fuel of %vehicle%", "[get] fuel percentage of %vehicle%"});
    }

    private void registerClasses() {
        Classes.registerClass((ClassInfo)new ClassInfo(DSObject.class, "dsobject").user(new String[]{"dsobject"}).name("dsobject").parser((Parser)new ObjectParser()));
        Classes.registerClass((ClassInfo)new ClassInfo(DSMoveableObject.class, "vehicle").user(new String[]{"vehicle"}).name("vehicle").parser((Parser)new VehicleParser()));
        Classes.registerClass((ClassInfo)new ClassInfo(ObjectType.class, OBJECT_TYPE).user(new String[]{OBJECT_TYPE}).name(OBJECT_TYPE).parser((Parser)new ObjectTypeParser()));
    }

    public static DynamicStands getDynamicStands() {
        return dynamicStands;
    }
}

