/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.util;

import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EnumParser<E extends Enum<E>>
extends Parser<E> {
    private String pattern;
    private Map<String, E> enumParseMap = new HashMap<String, E>();
    private Class<E> enumClass;

    public EnumParser(Class<E> enumClass) {
        this.enumClass = enumClass;
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            this.enumParseMap.put(e.name().toLowerCase().replace('_', ' '), e);
            this.enumParseMap.put(e.name().toLowerCase().replace("_", ""), e);
        }
    }

    public String toString(E o, int flags) {
        String name = ((Enum)o).name().toLowerCase().replace('_', ' ');
        String pluralSuffix = (flags & 0xFFFFFFFE) != 0 ? (name.endsWith("s") ? "es" : "s") : "";
        return name + pluralSuffix;
    }

    public String toVariableNameString(E o) {
        return this.toString(o, 0);
    }

    public String getVariableNamePattern() {
        if (this.pattern == null) {
            this.pattern = "(";
            this.pattern = this.pattern + Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this::toVariableNameString).map(Pattern::quote).collect(Collectors.joining("|"));
            this.pattern = this.pattern + ")";
        }
        return this.pattern;
    }

    public E parse(String s, ParseContext context) {
        return (E)((Enum)this.enumParseMap.get(s.toLowerCase()));
    }
}

