/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.HashSet;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Members of Faction")
@Description(value={"The members of a faction"})
@Examples(value={"remove player from player's faction"})
public class ExprMembersOfFaction
extends SimpleExpression<ConquerPlayer> {
    private Expression<ConquerFaction> factions;

    protected ConquerPlayer[] get(Event e) {
        ConquerFaction[] factions;
        HashSet<ConquerPlayer> players = new HashSet<ConquerPlayer>();
        for (ConquerFaction faction : factions = (ConquerFaction[])this.factions.getArray(e)) {
            if (faction == null) continue;
            players.addAll(Arrays.asList(faction.getMembers()));
        }
        return players.toArray(new ConquerPlayer[players.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ConquerPlayer> getReturnType() {
        return ConquerPlayer.class;
    }

    public String toString(Event e, boolean debug) {
        return "members of " + this.factions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return new Class[]{ConquerPlayer.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        ConquerPlayer player = (ConquerPlayer)delta[0];
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        if (factions.length == 0) {
            return;
        }
        ConquerFaction faction = factions[0];
        if (faction == null) {
            return;
        }
        if (mode == Changer.ChangeMode.ADD) {
            faction.addMember(player);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            faction.removeMember(player);
        }
    }

    static {
        Skript.registerExpression(ExprMembersOfFaction.class, ConquerPlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all] [the] (members|players) of %conquerfactions%", "%conquerfactions%'[s] (members|players)"});
    }
}

