/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.Relation;
import org.bukkit.event.Event;

@Name(value="Relation of Factions")
@Description(value={"The relation between two factions"})
@Examples(value={"on death of player:", "\tif relationship between victim's faction to attacker's faction is enemy:", "\t\tbroadcast \"Oof, %attacker's faction% just killed a player on %victim's faction%\""})
public class ExprFactionRelations
extends SimpleExpression<Relation> {
    private Expression<ConquerFaction> factions;
    private Expression<ConquerFaction> otherFactions;

    protected Relation[] get(Event e) {
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        ConquerFaction[] otherFactions = (ConquerFaction[])this.otherFactions.getArray(e);
        if (factions == null || otherFactions == null) {
            return null;
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (ConquerFaction faction : factions) {
            if (faction == null) continue;
            for (ConquerFaction otherFaction : otherFactions) {
                if (otherFaction == null) continue;
                relations.add(faction.getRelationTo(otherFaction));
            }
        }
        return relations.toArray(new Relation[relations.size()]);
    }

    public boolean isSingle() {
        return this.factions.isSingle() && this.otherFactions.isSingle();
    }

    public Class<? extends Relation> getReturnType() {
        return Relation.class;
    }

    public String toString(Event e, boolean debug) {
        return "relation between " + this.factions.toString(e, debug) + " and " + this.otherFactions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        this.otherFactions = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Relation.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        ConquerFaction[] otherFactions = (ConquerFaction[])this.otherFactions.getArray(e);
        if (factions == null || otherFactions == null) {
            return;
        }
        Relation relation = Relation.NEUTRAL;
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0 || delta[0] == null) {
                return;
            }
            relation = (Relation)((Object)delta[0]);
        }
        for (ConquerFaction faction : factions) {
            if (faction == null) continue;
            for (ConquerFaction otherFaction : otherFactions) {
                if (otherFaction == null) continue;
                faction.setRelationBetween(otherFaction, relation);
            }
        }
    }

    static {
        Skript.registerExpression(ExprFactionRelations.class, Relation.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] relation[ship][s] (between|across|for|to|of) [the] [faction][s] %conquerfactions% [and] [to] [the] [faction][s] %conquerfactions%"});
    }
}

