/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.savagefactions;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Factions;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.sender.AllPermissionsSender;
import me.andrew28.addons.conquer.impl.savagefactions.SFFaction;
import me.andrew28.addons.conquer.impl.savagefactions.SFPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SFPlayer
extends ConquerPlayer {
    private static Map<Object, SFPlayer> cache = new WeakHashMap<Object, SFPlayer>();
    private SFPlugin plugin;
    private Factions factions;
    private FPlayer fPlayer;
    private OfflinePlayer offlinePlayer;

    private SFPlayer(SFPlugin plugin, FPlayer fPlayer) {
        this.plugin = plugin;
        this.factions = plugin.getFactions();
        this.fPlayer = fPlayer;
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(fPlayer.getId()));
    }

    private SFPlayer(SFPlugin plugin, OfflinePlayer player) {
        this.plugin = plugin;
        this.offlinePlayer = player;
        this.fPlayer = player instanceof Player ? plugin.getFPlayers().getByPlayer((Player)player) : plugin.getFPlayers().getByOfflinePlayer(player);
    }

    public static SFPlayer get(SFPlugin plugin, FPlayer fPlayer) {
        if (fPlayer == null) {
            return null;
        }
        if (!cache.containsKey(fPlayer)) {
            SFPlayer fuPlayer = new SFPlayer(plugin, fPlayer);
            cache.put(fPlayer, fuPlayer);
            return fuPlayer;
        }
        return cache.get(fPlayer);
    }

    public static SFPlayer get(SFPlugin plugin, OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (!cache.containsKey(player)) {
            SFPlayer fuPlayer = new SFPlayer(plugin, player);
            cache.put(player, fuPlayer);
            return fuPlayer;
        }
        return cache.get(player);
    }

    @Override
    public String getName() {
        return this.offlinePlayer.getName();
    }

    @Override
    public boolean hasFaction() {
        return this.fPlayer.getFaction().isNormal();
    }

    @Override
    public ConquerFaction getFaction() {
        return SFFaction.get(this.plugin, this.fPlayer.getFaction());
    }

    @Override
    public void setFaction(ConquerFaction faction) {
        this.fPlayer.setFaction(faction == null ? this.factions.getWilderness() : ((SFFaction)faction).getRawFaction());
    }

    @Override
    public boolean isAutoClaiming() {
        return this.fPlayer.getAutoClaimFor() != null;
    }

    @Override
    public void setAutoClaiming(boolean autoClaiming) {
        this.fPlayer.setAutoClaimFor(this.fPlayer.getFaction());
    }

    @Override
    public Date getLastActivity() {
        return new Date(this.fPlayer.getLastLoginTime());
    }

    @Override
    public void setLastActivity(Date date) {
        this.fPlayer.setLastFrostwalkerMessage();
    }

    @Override
    public ConquerPlayer.Role getRole() {
        return this.plugin.translate(this.fPlayer.getRole());
    }

    @Override
    public void setRole(ConquerPlayer.Role role) {
        this.fPlayer.setRole(this.plugin.translate(role));
    }

    @Override
    public String getTitle() {
        return this.fPlayer.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fPlayer.setTitle((CommandSender)new AllPermissionsSender(), title);
    }

    @Override
    public void leaveFaction() {
        this.fPlayer.leave(false);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    @Override
    public double getPower() {
        return this.fPlayer.getPower();
    }

    @Override
    public void setPower(double power) {
        this.fPlayer.alterPower(power - this.getPower());
    }

    @Override
    public double getMaximumPower() {
        return this.fPlayer.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.fPlayer.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.fPlayer.setPowerBoost(powerBoost);
    }

    public FPlayer getRawPlayer() {
        return this.fPlayer;
    }
}

