/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.savagefactions;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.util.LazyLocation;
import com.massivecraft.factions.zcore.util.TL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.sender.MessageOnlySender;
import me.andrew28.addons.conquer.impl.savagefactions.SFClaim;
import me.andrew28.addons.conquer.impl.savagefactions.SFPlayer;
import me.andrew28.addons.conquer.impl.savagefactions.SFPlugin;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class SFFaction
extends ConquerFaction {
    private static final String DEFAULT_DESCRIPTION = TL.GENERIC_DEFAULTDESCRIPTION.toString();
    private static Map<Faction, SFFaction> cache = new WeakHashMap<Faction, SFFaction>();
    private SFPlugin plugin;
    private Factions factions;
    private FPlayers fPlayers;
    private Board board;
    private Faction faction;
    private CommandSender sender;
    private Map<String, Location> warpMap;

    private SFFaction(SFPlugin plugin, Faction faction) {
        this.plugin = plugin;
        this.factions = plugin.getFactions();
        this.fPlayers = plugin.getFPlayers();
        this.board = plugin.getBoard();
        this.faction = faction;
    }

    public static SFFaction get(SFPlugin plugin, Faction faction) {
        if (faction == null || !faction.isNormal()) {
            return null;
        }
        if (!cache.containsKey(faction)) {
            SFFaction fuFaction = new SFFaction(plugin, faction);
            cache.put(faction, fuFaction);
            return fuFaction;
        }
        return cache.get(faction);
    }

    @Override
    public String getId() {
        return this.faction.getId();
    }

    @Override
    public void setId(String id) {
        this.faction.setId(id);
    }

    @Override
    public String getName() {
        return this.faction.getTag();
    }

    @Override
    public void setName(String name) {
        this.faction.setTag(name);
    }

    @Override
    public String getDescription() {
        String description = this.faction.getDescription();
        return description.equals(DEFAULT_DESCRIPTION) ? null : description;
    }

    @Override
    public void setDescription(String description) {
        this.faction.setDescription(description == null ? DEFAULT_DESCRIPTION : description);
    }

    @Override
    public String getMotd() {
        return null;
    }

    @Override
    public void setMotd(String motd) {
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.faction.getFoundedDate());
    }

    @Override
    public void setCreationDate(Date date) {
        this.faction.setFoundedDate(date.getTime());
    }

    @Override
    public double getPower() {
        return this.faction.getPower();
    }

    @Override
    public void setPower(double power) {
        this.faction.setPermanentPower(Integer.valueOf((int)power));
    }

    @Override
    public double getMaximumPower() {
        return this.faction.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.faction.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.faction.setPowerBoost(powerBoost);
    }

    @Override
    public ConquerPlayer getLeader() {
        return SFPlayer.get(this.plugin, this.faction.getFPlayerAdmin());
    }

    @Override
    public void setLeader(ConquerPlayer leader) {
        leader.setRole(ConquerPlayer.Role.ADMIN);
    }

    @Override
    public Location getHome() {
        return this.faction.getHome();
    }

    @Override
    public void setHome(Location home) {
        this.faction.setHome(home);
    }

    @Override
    public ConquerPlayer[] getMembers() {
        return (ConquerPlayer[])this.faction.getFPlayers().stream().map(fPlayer -> SFPlayer.get(this.plugin, fPlayer)).toArray(ConquerPlayer[]::new);
    }

    @Override
    public void addMember(ConquerPlayer member) {
        ((SFPlayer)member).getRawPlayer().setFaction(this.faction);
    }

    @Override
    public void removeMember(ConquerPlayer member) {
        this.faction.removeFPlayer(((SFPlayer)member).getRawPlayer());
    }

    @Override
    public CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new MessageOnlySender(){

                public void sendMessage(String message) {
                    SFFaction.this.faction.sendMessage(message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    SFFaction.this.faction.sendMessage(Arrays.asList(messages));
                }
            };
        }
        return this.sender;
    }

    @Override
    public Map<String, Location> getWarps() {
        if (this.warpMap == null) {
            this.warpMap = new AbstractMap<String, Location>(){

                @Override
                public Location get(Object key) {
                    if (!(key instanceof String)) {
                        return null;
                    }
                    LazyLocation lazyLocation = SFFaction.this.faction.getWarp((String)key);
                    return lazyLocation == null ? null : lazyLocation.getLocation();
                }

                @Override
                public boolean containsKey(Object key) {
                    return key instanceof String && SFFaction.this.faction.isWarp((String)key);
                }

                @Override
                public Location put(String key, Location value) {
                    Location previous = this.get(key);
                    SFFaction.this.faction.setWarp(key, new LazyLocation(value));
                    return previous;
                }

                @Override
                public Set<Map.Entry<String, Location>> entrySet() {
                    return SFFaction.this.faction.getWarps().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Location>((String)entry.getKey(), ((LazyLocation)entry.getValue()).getLocation())).collect(Collectors.toSet());
                }

                @Override
                public void clear() {
                    SFFaction.this.faction.clearWarps();
                }

                @Override
                public Location remove(Object key) {
                    if (!(key instanceof String)) {
                        return null;
                    }
                    Location previous = this.get(key);
                    SFFaction.this.faction.removeWarp((String)key);
                    return previous;
                }

                @Override
                public int size() {
                    return super.size();
                }
            };
        }
        return this.warpMap;
    }

    @Override
    public boolean hasWarpPassword(String warp) {
        return this.faction.hasWarpPassword(warp);
    }

    @Override
    public boolean isWarpPassword(String warp, String password) {
        return this.faction.isWarpPassword(warp, password);
    }

    @Override
    public String getWarpPassword(String warp) {
        return this.hasWarpPassword(warp) ? "" : null;
    }

    @Override
    public void setWarpPassword(String warp, String password) {
        this.faction.setWarpPassword(warp, password);
    }

    @Override
    public Set<ConquerPlayer> getInvited() {
        return this.faction.getInvites().stream().map(id -> this.fPlayers.getById(id)).map(fPlayer -> SFPlayer.get(this.plugin, fPlayer)).collect(Collectors.toSet());
    }

    @Override
    public void invite(ConquerPlayer player) {
        this.faction.invite(((SFPlayer)player).getRawPlayer());
    }

    @Override
    public void deinvite(ConquerPlayer player) {
        this.faction.deinvite(((SFPlayer)player).getRawPlayer());
    }

    @Override
    public boolean isPeaceful() {
        return this.faction.isPeaceful();
    }

    @Override
    public void setPeaceful(boolean peaceful) {
        this.faction.setPeaceful(peaceful);
    }

    @Override
    public boolean isOpen() {
        return this.faction.getOpen();
    }

    @Override
    public void setOpen(boolean open) {
        this.faction.setOpen(open);
    }

    @Override
    public Relation getRelationTo(ConquerFaction faction) {
        return this.plugin.translate(this.faction.getRelationTo((RelationParticipator)((SFFaction)faction).getRawFaction()));
    }

    @Override
    public void setRelationBetween(ConquerFaction faction, Relation relation) {
        this.faction.setRelationWish(((SFFaction)faction).getRawFaction(), this.plugin.translate(relation));
    }

    @Override
    public ConquerClaim<?>[] getClaims() {
        return (ConquerClaim[])this.faction.getAllClaims().stream().map(fLocation -> SFClaim.get(this.plugin, fLocation)).toArray(ConquerClaim[]::new);
    }

    @Override
    public void claim(ConquerClaim<?> claim) {
        this.board.setFactionAt(this.faction, ((SFClaim)claim).getRawFLocation());
    }

    @Override
    public void claim(Location location) {
        this.board.setFactionAt(this.faction, this.plugin.translate(location));
    }

    @Override
    public void unclaim(ConquerClaim<?> claim) {
        this.board.setFactionAt(this.factions.getWilderness(), ((SFClaim)claim).getRawFLocation());
    }

    @Override
    public void unclaim(Location location) {
        this.board.setFactionAt(this.factions.getWilderness(), this.plugin.translate(location));
    }

    @Override
    public void disband() {
        this.factions.removeFaction(this.faction.getId());
    }

    @Override
    public int getTNT() {
        return this.faction.getTnt();
    }

    @Override
    public void addTNT(int amount) {
        this.faction.addTnt(amount);
    }

    @Override
    public void removeTNT(int amount) {
        this.faction.takeTnt(amount);
    }

    @Override
    public Location getCheckpoint() {
        return this.faction.getCheckpoint();
    }

    @Override
    public void setCheckpoint(Location location) {
        this.faction.setCheckpoint(location);
    }

    @Override
    public List<String> getRules() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return SFFaction.this.faction.getRule(index);
            }

            @Override
            public String remove(int index) {
                String old = null;
                if (SFFaction.this.faction.getRulesMap().containsKey(index)) {
                    old = (String)SFFaction.this.faction.getRulesMap().get(index);
                }
                SFFaction.this.faction.getRulesMap().remove(index);
                return old;
            }

            @Override
            public void add(int index, String element) {
                SFFaction.this.faction.getRulesMap().put(index, element);
            }

            @Override
            public int size() {
                return SFFaction.this.faction.getRulesMap().size();
            }

            @Override
            public void clear() {
                SFFaction.this.faction.getRulesMap().clear();
            }
        };
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("id", (Object)this.faction.getId());
        return fields;
    }

    public Faction getRawFaction() {
        return this.faction;
    }
}

