/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.mfactions;

import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.event.EventFactionsChunkChangeType;
import com.massivecraft.factions.event.EventFactionsChunksChange;
import com.massivecraft.factions.event.EventFactionsCreate;
import com.massivecraft.factions.event.EventFactionsDisband;
import com.massivecraft.factions.event.EventFactionsMembershipChange;
import com.massivecraft.factions.event.EventFactionsPowerChange;
import com.massivecraft.factions.event.EventFactionsRelationChange;
import com.massivecraft.massivecore.ps.PS;
import java.util.Map;
import java.util.Set;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.EventForwarder;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.events.ConquerFactionCreateEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionDisbandEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionJoinEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionLeaveEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationWishEvent;
import me.andrew28.addons.conquer.api.events.ConquerLandClaimEvent;
import me.andrew28.addons.conquer.api.events.ConquerPlayerFactionEvent;
import me.andrew28.addons.conquer.api.events.ConquerPowerLossEvent;
import me.andrew28.addons.conquer.api.events.ConquerUnclaimAllEvent;
import me.andrew28.addons.conquer.impl.mfactions.MSClaim;
import me.andrew28.addons.conquer.impl.mfactions.MSFaction;
import me.andrew28.addons.conquer.impl.mfactions.MSPlayer;
import me.andrew28.addons.conquer.impl.mfactions.MSPlugin;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;

class MSEventForwarder
extends EventForwarder {
    private MSPlugin plugin;

    MSEventForwarder(MSPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFactionCreate(EventFactionsCreate event) {
        ConquerFactionCreateEvent forwardEvent = new ConquerFactionCreateEvent(MSPlayer.get(this.plugin, event.getMPlayer()), event.getFactionName());
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionDisband(EventFactionsDisband event) {
        ConquerFactionDisbandEvent forwardEvent = new ConquerFactionDisbandEvent(MSFaction.get(this.plugin, event.getFaction()), MSPlayer.get(this.plugin, event.getMPlayer()));
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMembershipChange(EventFactionsMembershipChange event) {
        ConquerPlayerFactionEvent forwardEvent;
        MSFaction faction = MSFaction.get(this.plugin, event.getNewFaction());
        MSPlayer player = MSPlayer.get(this.plugin, event.getMPlayer());
        switch (event.getReason()) {
            case JOIN: 
            case CREATE: {
                forwardEvent = new ConquerFactionJoinEvent(faction, player);
                break;
            }
            case LEAVE: 
            case KICK: 
            case DISBAND: {
                forwardEvent = new ConquerFactionLeaveEvent(faction, player);
                break;
            }
            default: {
                return;
            }
        }
        this.callEvent(forwardEvent);
        if (((Cancellable)forwardEvent).isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRelationChange(EventFactionsRelationChange event) {
        MSPlayer player = MSPlayer.get(this.plugin, event.getMPlayer());
        MSFaction faction = MSFaction.get(this.plugin, event.getFaction());
        MSFaction otherFaction = MSFaction.get(this.plugin, event.getOtherFaction());
        Relation oldRelation = this.plugin.translateRelation(event.getFaction().getRelationTo((RelationParticipator)event.getOtherFaction()));
        Relation newRelation = this.plugin.translateRelation(event.getNewRelation());
        ConquerFactionRelationWishEvent forwardWishEvent = new ConquerFactionRelationWishEvent(player, faction, otherFaction, oldRelation, newRelation);
        this.callEvent(forwardWishEvent);
        if (forwardWishEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        ConquerFactionRelationEvent forwardEvent = new ConquerFactionRelationEvent(faction, otherFaction, oldRelation, newRelation);
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClaimChange(EventFactionsChunksChange event) {
        MSFaction faction = MSFaction.get(this.plugin, event.getNewFaction());
        MSPlayer player = MSPlayer.get(this.plugin, event.getMPlayer());
        Set chunks = event.getChunks();
        Map chunkTypeMap = event.getChunkType();
        if (chunks.size() == ((ConquerFaction)faction).getClaims().length && chunkTypeMap.values().stream().allMatch(type -> type == EventFactionsChunkChangeType.SELL)) {
            ConquerUnclaimAllEvent forwardEvent = new ConquerUnclaimAllEvent(faction, player);
            this.callEvent(forwardEvent);
            if (forwardEvent.isCancelled()) {
                event.setCancelled(true);
            }
        }
        block5: for (PS chunk : chunks) {
            ConquerLandClaimEvent forwardEvent;
            EventFactionsChunkChangeType type2 = (EventFactionsChunkChangeType)chunkTypeMap.get(chunk);
            MSClaim claim = MSClaim.get(this.plugin, chunk);
            switch (type2) {
                case NONE: {
                    continue block5;
                }
                case BUY: {
                    forwardEvent = new ConquerLandClaimEvent(claim, true, faction, player);
                    break;
                }
                case CONQUER: 
                case PILLAGE: {
                    forwardEvent = new ConquerLandClaimEvent(claim, false, faction, player);
                    break;
                }
                default: {
                    return;
                }
            }
            this.callEvent(forwardEvent);
            if (!((Cancellable)forwardEvent).isCancelled()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPowerChange(EventFactionsPowerChange event) {
        MSPlayer player = MSPlayer.get(this.plugin, event.getMPlayer());
        double oldPower = player.getPower();
        double newPower = event.getNewPower();
        if (newPower < oldPower) {
            ConquerPowerLossEvent forwardEvent = new ConquerPowerLossEvent(((ConquerPlayer)player).getFaction(), player);
            this.callEvent(forwardEvent);
            if (forwardEvent.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }
}

