/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.legacyfactions;

import ch.njol.yggdrasil.Fields;
import java.util.Map;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlugin;
import net.redstoneore.legacyfactions.FLocation;
import net.redstoneore.legacyfactions.entity.Board;
import net.redstoneore.legacyfactions.entity.Faction;
import net.redstoneore.legacyfactions.entity.FactionColl;
import org.bukkit.Chunk;

public class LFClaim
extends ConquerClaim<Chunk> {
    private static Map<Object, LFClaim> cache = new WeakHashMap<Object, LFClaim>();
    private Chunk chunk;
    private FactionColl factionColl;
    private Board board;
    private FLocation fLocation;

    private LFClaim(LFPlugin plugin, FLocation fLocation) {
        this.chunk = fLocation.getChunk();
        this.factionColl = plugin.getFactionColl();
        this.board = plugin.getBoard();
        this.fLocation = fLocation;
    }

    private LFClaim(LFPlugin plugin, Chunk chunk) {
        this.chunk = chunk;
        this.factionColl = plugin.getFactionColl();
        this.board = plugin.getBoard();
        this.fLocation = new FLocation(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public static LFClaim get(LFPlugin plugin, FLocation fLocation) {
        if (fLocation == null) {
            return null;
        }
        if (!cache.containsKey(fLocation)) {
            LFClaim lfClaim = new LFClaim(plugin, fLocation);
            cache.put(fLocation, lfClaim);
            return lfClaim;
        }
        return cache.get(fLocation);
    }

    public static LFClaim get(LFPlugin plugin, Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        if (!cache.containsKey(chunk)) {
            LFClaim fuClaim = new LFClaim(plugin, chunk);
            cache.put(chunk, fuClaim);
        }
        return cache.get(chunk);
    }

    @Override
    public Chunk getRepresentation() {
        return this.chunk;
    }

    @Override
    public ClaimType getType() {
        Faction faction = this.board.getFactionAt(this.fLocation);
        if (faction.isWilderness()) {
            return ClaimType.WILDERNESS;
        }
        if (faction.getId().equals("-1")) {
            return ClaimType.SAFE_ZONE;
        }
        if (faction.getId().equals("-2")) {
            return ClaimType.WAR_ZONE;
        }
        return ClaimType.FACTION;
    }

    @Override
    public void setTo(ClaimType type) {
        Faction faction;
        switch (type) {
            case WILDERNESS: {
                faction = FactionColl.get((Object)"0");
                break;
            }
            case SAFE_ZONE: {
                faction = FactionColl.get((Object)"-1");
                break;
            }
            case WAR_ZONE: {
                faction = FactionColl.get((Object)"-2");
                break;
            }
            default: {
                return;
            }
        }
        this.board.setFactionAt(faction, this.fLocation);
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("chunk", (Object)this.chunk);
        return fields;
    }

    public FLocation getRawFLocation() {
        return this.fLocation;
    }
}

