/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.factionsuuid;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.util.LazyLocation;
import com.massivecraft.factions.zcore.util.TL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.sender.MessageOnlySender;
import me.andrew28.addons.conquer.impl.factionsuuid.FUClaim;
import me.andrew28.addons.conquer.impl.factionsuuid.FUPlayer;
import me.andrew28.addons.conquer.impl.factionsuuid.FUPlugin;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class FUFaction
extends ConquerFaction {
    private static final String DEFAULT_DESCRIPTION = TL.GENERIC_DEFAULTDESCRIPTION.toString();
    private static Map<Faction, FUFaction> cache = new WeakHashMap<Faction, FUFaction>();
    private FUPlugin plugin;
    private Factions factions;
    private FPlayers fPlayers;
    private Board board;
    private Faction faction;
    private CommandSender sender;
    private Map<String, Location> warpMap;

    private FUFaction(FUPlugin plugin, Faction faction) {
        this.plugin = plugin;
        this.factions = plugin.getFactions();
        this.fPlayers = plugin.getFPlayers();
        this.board = plugin.getBoard();
        this.faction = faction;
    }

    public static FUFaction get(FUPlugin plugin, Faction faction) {
        if (faction == null || !faction.isNormal()) {
            return null;
        }
        if (!cache.containsKey(faction)) {
            FUFaction fuFaction = new FUFaction(plugin, faction);
            cache.put(faction, fuFaction);
            return fuFaction;
        }
        return cache.get(faction);
    }

    @Override
    public String getId() {
        return this.faction.getId();
    }

    @Override
    public void setId(String id) {
        this.faction.setId(id);
    }

    @Override
    public String getName() {
        return this.faction.getTag();
    }

    @Override
    public void setName(String name) {
        this.faction.setTag(name);
    }

    @Override
    public String getDescription() {
        String description = this.faction.getDescription();
        return description.equals(DEFAULT_DESCRIPTION) ? null : description;
    }

    @Override
    public void setDescription(String description) {
        this.faction.setDescription(description == null ? DEFAULT_DESCRIPTION : description);
    }

    @Override
    public String getMotd() {
        return null;
    }

    @Override
    public void setMotd(String motd) {
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.faction.getFoundedDate());
    }

    @Override
    public void setCreationDate(Date date) {
        this.faction.setFoundedDate(date.getTime());
    }

    @Override
    public double getPower() {
        return this.faction.getPower();
    }

    @Override
    public void setPower(double power) {
        this.faction.setPermanentPower(Integer.valueOf((int)power));
    }

    @Override
    public double getMaximumPower() {
        return this.faction.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.faction.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.faction.setPowerBoost(powerBoost);
    }

    @Override
    public ConquerPlayer getLeader() {
        return FUPlayer.get(this.plugin, this.faction.getFPlayerAdmin());
    }

    @Override
    public void setLeader(ConquerPlayer leader) {
        leader.setRole(ConquerPlayer.Role.ADMIN);
    }

    @Override
    public Location getHome() {
        return this.faction.getHome();
    }

    @Override
    public void setHome(Location home) {
        this.faction.setHome(home);
    }

    @Override
    public ConquerPlayer[] getMembers() {
        return (ConquerPlayer[])this.faction.getFPlayers().stream().map(fPlayer -> FUPlayer.get(this.plugin, fPlayer)).toArray(ConquerPlayer[]::new);
    }

    @Override
    public void addMember(ConquerPlayer member) {
        ((FUPlayer)member).getRawPlayer().setFaction(this.faction);
    }

    @Override
    public void removeMember(ConquerPlayer member) {
        this.faction.removeFPlayer(((FUPlayer)member).getRawPlayer());
    }

    @Override
    public CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new MessageOnlySender(){

                public void sendMessage(String message) {
                    FUFaction.this.faction.sendMessage(message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    FUFaction.this.faction.sendMessage(Arrays.asList(messages));
                }
            };
        }
        return this.sender;
    }

    @Override
    public Map<String, Location> getWarps() {
        if (this.warpMap == null) {
            this.warpMap = new AbstractMap<String, Location>(){

                @Override
                public Location get(Object key) {
                    if (!(key instanceof String)) {
                        return null;
                    }
                    LazyLocation lazyLocation = FUFaction.this.faction.getWarp((String)key);
                    return lazyLocation == null ? null : lazyLocation.getLocation();
                }

                @Override
                public boolean containsKey(Object key) {
                    return key instanceof String && FUFaction.this.faction.isWarp((String)key);
                }

                @Override
                public Location put(String key, Location value) {
                    Location previous = this.get(key);
                    FUFaction.this.faction.setWarp(key, new LazyLocation(value));
                    return previous;
                }

                @Override
                public Set<Map.Entry<String, Location>> entrySet() {
                    return FUFaction.this.faction.getWarps().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Location>((String)entry.getKey(), ((LazyLocation)entry.getValue()).getLocation())).collect(Collectors.toSet());
                }

                @Override
                public void clear() {
                    FUFaction.this.faction.clearWarps();
                }

                @Override
                public Location remove(Object key) {
                    if (!(key instanceof String)) {
                        return null;
                    }
                    Location previous = this.get(key);
                    FUFaction.this.faction.removeWarp((String)key);
                    return previous;
                }

                @Override
                public int size() {
                    return super.size();
                }
            };
        }
        return this.warpMap;
    }

    @Override
    public boolean hasWarpPassword(String warp) {
        return this.faction.hasWarpPassword(warp);
    }

    @Override
    public boolean isWarpPassword(String warp, String password) {
        return this.faction.isWarpPassword(warp, password);
    }

    @Override
    public String getWarpPassword(String warp) {
        return this.hasWarpPassword(warp) ? "" : null;
    }

    @Override
    public void setWarpPassword(String warp, String password) {
        this.faction.setWarpPassword(warp, password);
    }

    @Override
    public Set<ConquerPlayer> getInvited() {
        return this.faction.getInvites().stream().map(id -> this.fPlayers.getById(id)).map(fPlayer -> FUPlayer.get(this.plugin, fPlayer)).collect(Collectors.toSet());
    }

    @Override
    public void invite(ConquerPlayer player) {
        this.faction.invite(((FUPlayer)player).getRawPlayer());
    }

    @Override
    public void deinvite(ConquerPlayer player) {
        this.faction.deinvite(((FUPlayer)player).getRawPlayer());
    }

    @Override
    public boolean isPeaceful() {
        return this.faction.isPeaceful();
    }

    @Override
    public void setPeaceful(boolean peaceful) {
        this.faction.setPeaceful(peaceful);
    }

    @Override
    public boolean isOpen() {
        return this.faction.getOpen();
    }

    @Override
    public void setOpen(boolean open) {
        this.faction.setOpen(open);
    }

    @Override
    public Relation getRelationTo(ConquerFaction faction) {
        return this.plugin.translate(this.faction.getRelationTo((RelationParticipator)((FUFaction)faction).getRawFaction()));
    }

    @Override
    public void setRelationBetween(ConquerFaction faction, Relation relation) {
        this.faction.setRelationWish(((FUFaction)faction).getRawFaction(), this.plugin.translate(relation));
    }

    @Override
    public ConquerClaim<?>[] getClaims() {
        return (ConquerClaim[])this.faction.getAllClaims().stream().map(fLocation -> FUClaim.get(this.plugin, fLocation)).toArray(ConquerClaim[]::new);
    }

    @Override
    public void claim(ConquerClaim<?> claim) {
        this.board.setFactionAt(this.faction, ((FUClaim)claim).getRawFLocation());
    }

    @Override
    public void claim(Location location) {
        this.board.setFactionAt(this.faction, this.plugin.translate(location));
    }

    @Override
    public void unclaim(ConquerClaim<?> claim) {
        this.board.setFactionAt(this.factions.getWilderness(), ((FUClaim)claim).getRawFLocation());
    }

    @Override
    public void unclaim(Location location) {
        this.board.setFactionAt(this.factions.getWilderness(), this.plugin.translate(location));
    }

    @Override
    public void disband() {
        this.factions.removeFaction(this.faction.getId());
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("id", (Object)this.faction.getId());
        return fields;
    }

    public Faction getRawFaction() {
        return this.faction;
    }
}

